
/* as296_main.c
 *
 * Programmer: DG1CPA@DB0CHZ.#SAX.DEU.EU
 *
 * Ham Radio Modem driver
 * for AS296 USB-Modem from AAtis (9600bd FSK, 4800bd FSK, 1200bd AFSK)
 *
 * This driver connects a AS296 USB Modem to a tty (pseudo-tty)
 * from the other side of the pseudo-tty you can connect a kiss-driver (kissattach)
 * The kissdriver has to use the "rmnc-crc" protocol
 *
 * Todo:
 * Slottime implemention
 *
 * This program is distributed under the GPL, version 2.
 */

//-------------------------------------------------------------DJ8SR-----
#define VERSION "0.1.7-DJ8SR"

#define _GNU_SOURCE
//-------------------------------------------------------------DJ8SR-----

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <usb.h>
#include "as296_lib.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/mman.h>
#include <termios.h>
#include <poll.h>
#include <errno.h>
#include <time.h>
#include <sys/wait.h>

#define FEND 0xC0     // Kiss Frame Ende

typedef struct {
  char modemstatus;
  char modemversion;
  char resyncCounter;
  char software_state; //0=ok 1=error
}mmap_type;

void as296_fatal (struct as296_context *as296, char *str)
{
  fprintf (stderr, "%s: %s\n", 
	   str, as296_get_error_string (as296));
  exit (1); 
}

void display_timestamp(void)
{
     time_t timenowx;
     struct tm *timenow;
     struct timeval tv;
     struct timezone tz;

     time(&timenowx);
     timenow = localtime(&timenowx);

     gettimeofday(&tv, &tz);
     printf("%02d:%02d:%02d:%03d ", timenow->tm_hour, timenow->tm_min, timenow->tm_sec, (int)tv.tv_usec/1000);
}

//print kiss packets
void printkiss(unsigned char *ptr,int len)
{
   int i;
   
   display_timestamp();
   for (i=0;i<len;i++)
       printf("%02X/",*ptr++);
   printf("\n");
}

//todo read /dev/urandom
unsigned int random_num(int randfd)
{
  static unsigned int random_seed=0;
  //random_seed = 28629 * random_seed + 157;
  read(randfd, &random_seed, sizeof(random_seed));
  return random_seed;
}


int main(int argc, char **argv)
{
  int fd, ret, randfd,optres, rxsize, usb_read, usb_write, txsize, len;
  int persistence=64, slottime=100, tty, dama=0, res;
  unsigned char mode=10, txdelay=22 ,rxdata[340*7], txdata[340*7], debug=0;;
  char *ptty = NULL;
  mmap_type *mmap_addr;
  caddr_t  adr;
  struct as296_context as296c;
  int errcount=0;
  struct termios tm;
  struct pollfd poll_fd0;
  int numvendor=0, snumvendor=0, numproduct=0, snumproduct=0;
//-------------------------------------------------------------DJ8SR-----
	int child_pid = 0;
	int wait_status;
	
	char *namepts = NULL;  /* name of the unix98 pts slave, which
	                        * the client has to use */
//-------------------------------------------------------------DJ8SR-----

  printf("AS296 Modem driver - Version: %s\n", VERSION);
  as296_init(&as296c);

  //parse command line options
  while ((optres = getopt (argc, argv, "m:t:hy:d:s:p:D:u:")) != -1) {
    switch (optres) {
    case 'm':
          printf("selected mode %s\n",optarg);
          len = strlen(optarg);
          if      (!strncasecmp(optarg, "9600", len))
            mode = 0;
          else if (!strncasecmp(optarg, "9696", len))
            mode = 0;
          else if (!strncasecmp(optarg, "9612", len))
            mode = 1;
          else if (!strncasecmp(optarg, "1296", len))
            mode = 2;
          else if (!strncasecmp(optarg, "1200", len))
            mode = 3;
          else if (!strncasecmp(optarg, "1212", len))
            mode = 3;
          else if (!strncasecmp(optarg, "4800", len))
            mode = 4;
          else if (!strncasecmp(optarg, "4848", len))
            mode = 4;
          else if (!strncasecmp(optarg, "pocs", len))
            mode = 5;
          else if (!strncasecmp(optarg, "poci", len))
            mode = 6;
          else {printf("invalid mode - modes available:\n9600\n1200\n4800\n9696\n9612\n1296\n1212\n4848\npocs\npoci\n");exit(0);}
          break;

     //DAMA
     case 'D':
         if(atoi(optarg)>0)
         {
           printf("use DAMA parameter\n");
	   persistence=255;
	   slottime=1;
	   dama=1;
         }
     break;
     
     //slottime
     case 's':
         if(dama==1) break;
         slottime = atoi(optarg);
         if ((slottime < 2000) && (slottime >= 0 ))
         {
           printf("use slottime %d ms\n",slottime);
         }
         else
         {
           printf("Error: please set a slottime less than 2000 ms\n");
           exit(0);
         }
     break;

     //persistence
     case 'p':
         if(dama==1) break;
         persistence = atoi(optarg);
         if ((persistence < 256) & (persistence >= 0 ))
         {
           printf("use persistence %d\n",persistence);
         }
         else
         {
           printf("Error: please set a persistence 0...255\n");
           exit(0);
         }
     break;
     //txdelay
     case 't':
         txdelay = atoi(optarg)/10;
         printf("set txdelay %s ms\n", optarg);
         break;
     //debug
     case 'd':
         debug = atoi(optarg);
	 printf("set debug mode %d\n",debug);
	 break;
     break;
     //tty name
     case 'y':
	 ptty = optarg;
         printf("use pseudotty %s\n", ptty);
         break;
	 
     case 'u':
         if (2 != sscanf(optarg, "%X:%X", &snumvendor,&snumproduct)) {
			fprintf(stderr, "-u requires vendor:product format ->auto usb-id search\n");
			numvendor = 0;
			numproduct = 0;
         } else {
			numvendor = snumvendor;
			numproduct = snumproduct;
         }
//	 printf("usbid=%X:%X",numvendor,numproduct);
         break;

     //help
     case 'h':
         printf("usb-as296-to-tty-d -t TXDELAY -m MODE -y PTTY -s Slottime -p Persistence -D DAMA -u USB_ID\nfor PTTY you can use a pseudo-tty example: /dev/ptyp9  ...(/dev/ptyp9 <-> /dev/ttyp9)\ntxdelay in ms\n");
      break;
    }
  }
  
  if(ptty == NULL)
  {
      printf("please setting a tty! (-y ...)\n");
      exit(EXIT_FAILURE);
  }

  //open pseudotty
  //open tty with O_NONBLOCK to prevent blocking problems with kissattach
  //              ->needs self block with poll()
  tty = open(ptty,O_RDWR|O_NONBLOCK);
  if (tty <= 0)
  {
     as296_fatal (&as296c, "can't open tty - is the tty in use???");
  }
  
//-------------------------------------------------------------DJ8SR-----
// Source: http://www.linux-ax25.org (kissattach)

	if (strcmp("/dev/ptmx", ptty) == 0) {
		/* get name of pts-device */
		if ((namepts = ptsname(tty)) == NULL) {
			fprintf(stderr, "Cannot get name of pts-device.\n");
			exit(EXIT_FAILURE);
		}
		/* unlock pts-device */
		if (unlockpt(tty) == -1) {
			fprintf(stderr, "Cannot unlock pts-device %s\n", namepts);
			exit(EXIT_FAILURE);
		}
		/* Users await the slave pty to be referenced in the 3d line */
		printf("Awaiting client connects on\n%s\n", namepts);
	}
//-------------------------------------------------------------DJ8SR-----


 /* set tty mode to raw */
  memset(&tm, 0, sizeof(tm));
  tm.c_cflag = CS8 | CREAD | CLOCAL;
  if (tcsetattr(tty, TCSANOW, &tm)) 
  {
     perror("master: tcsetattr");
     exit(-1);
  }

  fcntl(tty, F_SETFL, fcntl(tty, F_GETFL) & ~O_NONBLOCK);
  //open random device
  if((randfd = open("/dev/urandom",O_RDONLY))<0)
    as296_fatal (&as296c, "Can't open /dev/urandom");
  
  //Shared memory init
  if((fd = open("/dev/zero",O_RDWR))<0)
    as296_fatal (&as296c, "Can't open /dev/zero");

  if((adr = mmap(0, sizeof(mmap_type), PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0)) == (caddr_t)-1)
    as296_fatal (&as296c, "Can't init shared memory");
 
  mmap_addr = (mmap_type *)adr;
  close(fd); //Mapping ready
restart:
  sleep(6);  
  //init process fault check
  mmap_addr->software_state = 0;
  
  
  as296c.as296_mode    = mode;    // mode 9600FSK usw...
  as296c.as296_txdelay = txdelay;  

  //search/wait for a modem as296 or as607
  do
  {
     //auto id search?
     if (numvendor == 0)
     {
        //probing modems
        res = as296_usb_open(&as296c, 0x7355, 0x0296);
        if(res < 0) res = as296_usb_open(&as296c, 0x7355, 0x0607);
     }
     else //direct id
     {
        res = as296_usb_open(&as296c, numvendor, numproduct);
     }
     if (res < 0) sleep(2); //if no modem sleep a moment
  }while(res < 0);
  printf("found Modem\n");
//-------------------------------------------------------------DJ8SR-----
	if (child_pid > 0) {
		printf("Child (%d)\n", child_pid);
		if (wait(&wait_status) != child_pid) {
          perror("wait()");
          
          return EXIT_FAILURE;
		}
		printf("Child is dead\n");
	} 
	child_pid = fork();
   switch(child_pid) //split process in rx-usb(parent) and tx-usb
//-------------------------------------------------------------DJ8SR-----
   {
/******* child process *****************************************/
     case -1:
     as296_fatal (&as296c, "Can't fork process");
     break;
     case 0: // child-process code tx-usb <- tty
     if(1 < debug) printf("tifl-prozess aktiv (usb<-tty)\n");
        for(;;)
	{ 
           //set tty filedescriptor poll struct
	   poll_fd0.fd = tty;
	   poll_fd0.events = POLLIN|POLLPRI;
	   poll_fd0.revents = 0;

           ret = poll(&poll_fd0, 1, 5000);	   
//	   printf("Pollstat %X\n", poll_fd0.revents);
           
           if(1 == mmap_addr->software_state)
	      exit(EXIT_FAILURE);           

	   if (ret == 0) continue; //poll timeout
           if (ret < 0)
	   {
	      if (errno == EINTR) //ignore
	                      continue;
	      mmap_addr->software_state=1;
              as296_fatal (&as296c, "tty poll error");
	   }

           if (poll_fd0.revents & POLLIN)
	   {
	      txsize = read(tty, txdata, sizeof(txdata)-1);
	      
	      if (txsize < 0)
	      {
	         mmap_addr->software_state=1;
	         as296_fatal (&as296c, "tty read error");
		 
	      }
	   
	      if (txsize > 0)
	      {
	         if (1<debug)
	         {
	            printf("tx:Modemstat: %02X\n",mmap_addr->modemstatus);
	            printf("%d Bytes read from tty\n",txsize);
                    printkiss(txdata, txsize);
                 }
	      
	         //check kiss-packet comming from tty?
                 if ( (txdata[0] != 0xC0) || (txsize < 4) || (txdata[txsize-1] != 0xC0) )
	         {
	            if (1<debug)
	            {
	               printf("wrong packet(no kiss) from tty! datasize=%d\n",txsize);
	               printkiss(txdata, txsize);
                    }
		    continue;
	         }
	         //printf("kisscheck ok!\n");
                 //wait a slottime if a persistence try is negativ
	         //and do it again 
	         while((random_num(randfd) % 256) > persistence)
	         {
	            if(3 < debug) printf("wait one slottime [slottime=%d persistence=%d]\n", slottime, persistence);
	            usleep(slottime*1000);
	         }

                 //wait DCD	      
	         while((mmap_addr->modemstatus & 0x04) && (!(mmap_addr->modemstatus & 0x08))) //wenn dcd & nicht TX ->warten
	         {
	            if(4 < debug) printf("DCD-Wait stat %02X\n", mmap_addr->modemstatus);
	            usleep(250); //250us
	         }

                 if(!(mmap_addr->modemstatus & 0x02)) //firmware 1.0g and later
                 {
//		    printf("txwait\n");
	            if((usb_write = as296_write_data(&as296c, (char*)txdata, txsize)) <0) //&txdata[tx_frack], tx_block)) < 0)
	            {
		       if(0 < usb_write)
		       {
	                  if (0 < debug)
		          { 
		             display_timestamp();
		             printf("usbtxerr (-110==timeout) %d\n",usb_write);
		          }
			  if (-110 != usb_write)
			  {
			     mmap_addr->software_state = 1; //signaling parent process error
			     perror("as296 usbwrite process ");
			     exit(EXIT_FAILURE);
			  }
		       }
		       //     as296_fatal (&as296c, "USB tx error");
	            }
//		    printf("txready\n");
	         }
	         else
	         {
	            printf("Modem not ready!\n");
	         }
	      }
           }
	}      
     break;
     
/*********** parent process *************************************************+++*/
     default: // parent process code rx-usb -> tty
	if(1 < debug) printf("parent-prozess aktiv (usb->tty)\n");
        for(;;)
	{
	    usb_read = rxsize = as296_read_data(&as296c, (char*)rxdata, 8);
	    
	    if(1 == mmap_addr->software_state)
	      exit(EXIT_FAILURE);           

	    if ((rxsize < 0) && (rxsize!= (-110))) // -110 ist timeout nach ca. 5sek ->timeout parameter
	    {
	        if (0 < debug) printf("usb_rx_ret=%d errcnt=%d\n",rxsize,errcount); //#,prob
                mmap_addr->software_state=1;
		perror("usb read procces");
		goto restart;
		exit(EXIT_FAILURE);
//		usleep(800);
//	        //if (errcount>3000000) as296_fatal (&as296c, "USB read error");
//		errcount++;
//		continue; //#,
	    }
	    if (rxsize > 0) 
            {
                if(2<debug)
		{		   
	           printf("p:%02X\n",mmap_addr->modemstatus);
		   printf("%d Bytes read from usb\n",rxsize);
		   printkiss(rxdata, rxsize);
		}
                
		//controllpaket from modem (DCD...)
                if ((rxdata[0] == FEND) && 
		    (rxdata[1] == 0x21) &&
		    (rxdata[7] == FEND))
		{
		                                         // [2] device address
		    mmap_addr->modemversion = rxdata[3]; // modem version
                    mmap_addr->modemstatus  = rxdata[4]; // tx and dcd status 0x04(dcd?) 0x08(modem_ptt?)
		                                         // [6]lsb [7]msb modem buffer
		    
		    if (mmap_addr->modemversion > 5)
		    {
		        mmap_addr->resyncCounter = rxdata[5]; // resync counter
		    }
		    continue;
                }
		if (write(tty, rxdata, 8)<0) //#, ab und falsche rxsize    rxsize)<0)
		   as296_fatal (&as296c, "tty tx error");
            }       
	}
  }
  return 0;
//  close(tty);
//  as296_usb_close(&as296c);
//  exit (0);
}
