#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2011 by Michael Conrad <do5mc at aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'
require 'aprs4r/APRS4RConfiguration'

include APRS4R


class ProfileStatusHandler

  @logger = APRS4RLogger.get_logger( "ProfileStatusHandler")


  def ProfileStatusHandler.header
    return "Status - Profile"
  end


  def ProfileStatusHandler.cgi_parameter( cgi, name)
    value = nil

    parameter = cgi.params[name]
    
    if parameter 
      value = parameter[0]
    end

    return value
  end


  def ProfileStatusHandler.handle_request( cgi)
    @@logger.info( "handle_request( cgi)")

    etc_dir = ENV['APRS4R_ETC'] || "/etc/aprs4r"
    @@logger.debug( "etc_dir: #{etc_dir}")

    action = "unknown"
    # action = "export" if cgi_parameter( cgi, 'export') # export will be handled by external download servlet
    action = "import" if cgi_parameter( cgi, 'import')
    action = "delete" if cgi_parameter( cgi, 'delete')

    @@logger.debug( "action: #{action}")

    config_file = nil

    if action == "export"
      # this action is handled by download servlet
    elsif action == "import"
      upload = cgi_parameter( cgi, 'file')

      @@logger.debug( "upload.class: #{upload.class}")
      # @@logger.debug( "upload: #{upload.extract}")
      @@logger.debug( "upload.local_path: #{upload.local_path}")
      @@logger.debug( "upload.original_filename: #{upload.original_filename}")
      @@logger.debug( "upload.content_type: #{upload.content_type}")
      
      if !upload.nil? 
        begin
          config_file = File.basename( upload.original_filename) if upload.original_filename

          if !config_file.nil?
            File.open( etc_dir + "/" + config_file, "w") { |file|
              if upload.respond_to?( :extract)
                file.puts( upload.extract.read)
              elsif upload.respond_to?( :read)
                file.puts( upload.read)
              end
            }

            APRS4RConfiguration.update_configuration( etc_dir + "/" + config_file)
          end

        rescue Exception => ex
          @@logger.warn( "Error importing file: #{config_file}, ex: #{ex}")
        end
      end
    elsif action == "delete"
      file = cgi_parameter( cgi, 'file')
      config_file = File.basename( file) if file

      begin
        File.delete( etc_dir + "/" + config_file)
      rescue Exception => ex
        @@logger.warn( "Error deleting file: #{config_file}, ex: #{ex}")
      end
    end


    output = "" 
    config_files = Array.new

    if config_file.nil? || config_file.empty?
      config_files << ["keine Auswahl", "keine Auswahl", true]
    else
      config_files << ["keine Auswahl", "keine Auswahl"]
    end

    Dir.new( etc_dir).sort.each { |name|
      
      if name =~ /\.yaml$/ && name != "default.yaml"

        if config_file == name
          config_files << [name, name, true]
        else 
          config_files << [name, name]
        end
      end
    }

    if config_file.nil? || config_file.empty?
      config_file = "nicht ausgewaehlt"
    end

    output = cgi.h2 { "Profil exportieren/importieren" } 

    output += cgi.table { 
      
      # export existing file
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/download.rb") { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Profil exportieren: " }
          } + 
          cgi.td( "WIDTH" => "200") {
            cgi.hidden( "dir", etc_dir) + 
            cgi.popup_menu( "NAME" => "file", "VALUES" => config_files) 
          } + 
          cgi.td { 
            cgi.submit( "Export", "export")
          }
        }
      } + 

      # import new file
      cgi.tr { 
        cgi.multipart_form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/status/profile") { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Profil importieren: " }
          } + 
          cgi.td( "WIDTH" => "200") { 
            cgi.file_field( "file", 20)
          } + 
          cgi.td { 
            cgi.submit( "Import", "import")
          }
        }
      } + 

      # delete existing file
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/status/profile") { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Profil l&ouml;schen: " }
          } + 
          cgi.td( "WIDTH" => "200") { 
            cgi.popup_menu( "NAME" => "file", "VALUES" => config_files) 
          } + 
          cgi.td { 
            cgi.submit( "Loeschen", "delete")
          }
        }
      }

    }
    
    return output
  end

end






