#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2011 by Michael Conrad <do5mc at aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r-web/AbstractHandler'

include APRS4R


class PasswordAdminHandler < AbstractHandler

  @@logger = APRS4RLogger.get_logger( "PasswordAdminHandler")


  def PasswordAdminHandler.header
    return "Admin - Passwort"
  end


  def PasswordAdminHandler.cgi_parameter( cgi, name)
    value = nil
    
    parameter = cgi.params[name]
    value = parameter[0] if parameter

    return value
  end


  def PasswordAdminHandler.handle_request( cgi)

    auth_file = ENV['APRS4R_WEB_AUTH'] || "/etc/aprs4r-web/lighttpd.auth"
    # logger.debug( "auth_file: #{auth_file}")

    action = "unknown"
    action = "update" if cgi_parameter( cgi, 'update')

    if action == "update"

      password = cgi_parameter( cgi, 'password')

      begin
        File.open( auth_file, "w") { |file|

          if !password.nil? && !password.empty?
            file.puts( "aprs4r:#{password}")
          else
            file.puts( "aprs4r:")
          end
        }
      rescue Exception => ex
        @@logger.warn( "auth_file: #{ex}")
      end
    end


    password_status = "nicht gesetzt"
    begin
      File.new( auth_file).each{ |line|
        if line =~ /^aprs4r/
          values = line.split( /:/)
          
          password_status = "gesetzt" if values.length == 2
        end
      }
    rescue Exception => ex
      # logger.warn( "auth_file: #{ex}")
    end


    output = "" 

    output += cgi.h2 { "APRS4R Web Passwort" }

    output += cgi.table { 
      cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/admin/password") { 
        
        cgi.tr { 
          cgi.td( "WIDTH" => "200", "ALIGN" => "left") { 
            cgi.big { "Passwort setzen: " }
          } + 
          cgi.td { 
            cgi.text_field( "password", "", 20)
          } + 
          cgi.td { 
            cgi.submit( "Neu setzen", "update")
          } 
        }
      }

    } 
     
    output += cgi.p { 
      cgi.big { "Achtung: "} + 
      "Mit dem Neusetzen des Web-Passwortes ist dies sofort g&uuml;tig !"
    }
    
    return output
  end

end



