#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2011 by Michael Conrad <do5mc at aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

include APRS4R


class LogStatusHandler

  @logger = APRS4RLogger.get_logger( "LogStatusHandler")


  def LogStatusHandler.header
    return "Status - Log"
  end


  def LogStatusHandler.handle_request( cgi)
    # logger.info( "handle_request( cgi)")

    log_dir = ENV['APRS4R_LOG'] || "/var/log/aprs4r"
    # logger.debug( "log_dir: #{log_dir}")

    output = ""

    # print out log
    log_log4r = Array.new
    begin
      File.open( log_dir + "/aprs4r.log").each{ |line|
        log_log4r << line.force_encoding( "ASCII-8BIT")
        
        if log_log4r.length > 50
          log_log4r.shift
        end
      }
    rescue Exception
    end
    
    output += cgi.h2 { "Daten-Log" } 
    if log_log4r.length > 0 
      output += cgi.small { cgi.small { cgi.pre { log_log4r.join( "") } } }
    else
      output += cgi.p { "Keine Meldungen" }
    end


    # print err log
    err_log4r = Array.new
    begin
      File.open( log_dir + "/aprs4r.err").each{ |line|
        err_log4r << line.force_encoding( "ASCII-8BIT")
        
        if err_log4r.length > 50
          err_log4r.shift
        end
      }
    rescue Exception
    end
    
    output += cgi.h2 { "Fehler-Log" } 
    if err_log4r.length > 0 
      output += cgi.small { cgi.small { cgi.pre { err_log4r.join( "") } } }
    else
      output += cgi.p { "Keine Meldungen" }
    end


    # print stdout log 
    log_stdout = Array.new
    begin
      File.open( log_dir + "/aprs4r-stdout.log").each{ |line|
        log_stdout << line.force_encoding( "ASCII-8BIT")
        
        if log_stdout.length > 20
          log_stdout.shift
        end
      }
    rescue Exception
    end
    
    output += cgi.h2 { "Standard-Ausgabe APRS4R Skript" } 
    if log_stdout.length > 0 
      output += cgi.small { cgi.small { cgi.pre { log_stdout.join( "") } } }
    else
      output += cgi.p { "Keine Meldungen" }
    end


    # print stderr log
    log_stderr = Array.new
    begin
      File.open( log_dir + "/aprs4r-stderr.log").each{ |line|
        log_stderr << line.force_encoding( "ASCII-8BIT")
        
        if log_stderr.length > 20
          log_stderr.shift
        end
      }
    rescue Exception
    end
    
    output += cgi.h2 { "Fehler-Ausgabe APRS4R Skript" } 
    if log_stderr.length > 0 
      output += cgi.small { cgi.small { cgi.pre { log_stderr.join( "") } } }
    else
      output += cgi.p { "Keine Meldungen" }
    end
    
    return output
  end

end






