#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2011 by Michael Conrad <do5mc at aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'cgi'
require 'yaml'

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRS4RConfiguration'

require 'aprs4r-web/AbstractHandler'

include APRS4R


class EditorSetupHandler < AbstractHandler

  @logger = APRS4RLogger.get_logger( "EditorSetupHandler")


  def EditorSetupHandler.header
    return "Setup - Editor"
  end

  def EditorSetupHandler.handle_request( cgi)

    # configuration = load_configuration( session)

    session = load_session 

    configuration = nil
    configuration = session['config'] if session

    return show_timeout( cgi) if configuration.nil?

    action = "show"
    action = "update" if cgi_parameter( cgi, "update")

    if action == "update"
      
      configuration_text = cgi_parameter( cgi, "editor")
      @logger.error( "configuration_text: #{configuration_text}")

      configuration = YAML.load( configuration_text)
      @logger.error( "configuration: #{configuration}")

      session['config'] = configuration
      session['changed'] = true
      session['timestamp'] = Time.now
      save_session( session)
    end
    
    
    output = "" 
    
    output += show_profile( cgi, session)

    output += show_changed( cgi, session)

    output += cgi.h2 { "Editor - Benutzung auf eigene Gefahr" }

    configuration_text = YAML::dump( configuration)

    output += cgi.table {
      
      cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/setup/editor") {
        # save existing file
        cgi.tr {
          cgi.td( "ALIGN" => "left") { 
            cgi.big { cgi.big { "&Auml;nderungen &uuml;bernehmen: " } }
          } + 
          cgi.td { 
            cgi.submit( "Uebernehmen", "update")
          }
        } + 
        cgi.textarea( "editor", 80, 30) { configuration_text }
      }
    }

    return output 
  end

end



