#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2011 by Michael Conrad <do5mc at aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

include APRS4R


class DebugStatusHandler

  @logger = APRS4RLogger.get_logger( "DebugStatusHandler")


  def DebugStatusHandler.header
    return "Status - Debug"
  end


  def DebugStatusHandler.cgi_parameter( cgi, name)
    value = nil

    parameter = cgi.params[name]
    
    if parameter 
      value = parameter[0]
    end

    return value
  end


  def DebugStatusHandler.handle_request( cgi)
    # logger.info( "handle_request( cgi)")

    tmp_dir = ENV['APRS4R_TMP'] || "/tmp"

    action = "unknown"
    action = "create" if cgi_parameter( cgi, 'create')
    # action = "export" if cgi_parameter( cgi, 'export') # export will be handled by external download servlet
    action = "delete" if cgi_parameter( cgi, 'delete')

    @@logger.debug( "action: #{action}")

    debug_file = nil

    if action == "export"
      # this action is handled by download servlet
    elsif action == "create" 
      @@logger.debug( "create action")
      
      system( "/usr/bin/aprs4r_crashreport > /dev/null")
      result = $?
      
    elsif action == "delete" 
      @@logger.debug( "delete action")

      file = cgi_parameter( cgi, 'file')
      debug_file = File.basename( file) if file

      begin
        File.delete( tmp_dir + "/" + debug_file)
        rescue Exception => ex
        logger.warn( "Error deleting file: #{tmp_file}, ex: #{ex}")
      end
    end


    debug_files = Array.new

    Dir.new( tmp_dir).sort.each { |name|
      if name =~ /aprs4r-crashreport-.*\.tar\.gz/
        debug_files << [name, name]
      end
    }


    output = cgi.h2 { "Crash-Report erstellen/runterladen" }
    
    output += cgi.table { 
      
      # create crash report archive
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/status/debug") { 
          cgi.td( "WIDTH" => "300") { 
            cgi.big { "Crash-Report erzeugen: " }
          } + 
          cgi.td { 
          } + 
          cgi.td { 
            cgi.submit( "Erstellen", "create")
          }
        }
      } + 

      # export existing file
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/download.rb") { 
          cgi.td( "WIDTH" => "300") { 
            cgi.big { "Crash-Report exportieren: " }
          } + 
          cgi.td( "WIDTH" => "200") {
            cgi.hidden( "dir", tmp_dir) + 
            cgi.popup_menu( "NAME" => "file", "VALUES" => debug_files) 
          } + 
          cgi.td { 
            cgi.submit( "Export", "export")
          }
        }
      } + 

      # delete existing file
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/status/debug") { 
          cgi.td( "WIDTH" => "300") { 
            cgi.big { "Crash-Report l&ouml;schen: " }
          } + 
          cgi.td( "WIDTH" => "200") { 
            cgi.popup_menu( "NAME" => "file", "VALUES" => debug_files) 
          } + 
          cgi.td { 
            cgi.submit( "Loeschen", "delete")
          }
        }
      }

    }

    return output
  end

end






