#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2011 by Michael Conrad <do5mc at aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

include APRS4R


class BackupStatusHandler

  @logger = APRS4RLogger.get_logger( "BackupStatusHandler")


  def BackupStatusHandler.header
    return "Status - Backup"
  end


  def BackupStatusHandler.cgi_parameter( cgi, name)
    value = nil

    parameter = cgi.params[name]
    
    if parameter 
      value = parameter[0]
    end

    return value
  end


  def BackupStatusHandler.handle_request( cgi)
    @@logger.info( "handle_request( cgi)")

    etc_dir = ENV['APRS4R_ETC'] || "/etc/aprs4r"
    backup_dir = etc_dir + "/backups"
    @@logger.debug( "backup_dir: #{backup_dir}")

    action = "unknown"
    # action = "export" if cgi_parameter( cgi, 'export') # export will be handled by external download servlet
    action = "delete" if cgi_parameter( cgi, 'delete')

    @@logger.debug( "action: #{action}")

    config_file = nil

    if action == "export"
      # this action is handled by download servlet
    elsif action == "delete"
      file = cgi_parameter( cgi, 'file')
      config_file = File.basename( file) if file

      begin
        File.delete( backup_dir + "/" + config_file)
      rescue Exception => ex
        @@logger.warn( "Error deleting file: #{config_file}, ex: #{ex}")
      end
    end


    output = "" 
    config_files = Array.new

    if config_file.nil? || config_file.empty?
      config_files << ["keine Auswahl", "keine Auswahl", true]
    else
      config_files << ["keine Auswahl", "keine Auswahl"]
    end

    Dir.new( backup_dir).sort.each { |name|
      
      if name =~ /\.yaml$/ 

        timestamp, file = name.split( /-/, 2)
        time = Time.at( timestamp.to_i)
        text = time.strftime( "%Y-%m-%d %H:%M:%S")

        if config_file == name
          config_files << [name, "#{file} #{text}", true]
        else 
          config_files << [name, "#{file} #{text}"]
        end
      end
    }

    if config_file.nil? || config_file.empty?
      config_file = "nicht ausgewaehlt"
    end

    output = cgi.h2 { "Backup exportieren" } 

    output += cgi.table { 
      
      # export existing file
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/download.rb") { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Backup exportieren: " }
          } + 
          cgi.td( "WIDTH" => "200") {
            cgi.hidden( "dir", backup_dir) + 
            cgi.popup_menu( "NAME" => "file", "VALUES" => config_files) 
          } + 
          cgi.td { 
            cgi.submit( "Export", "export")
          }
        }
      } + 

      # delete existing file
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/status/backup") { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Backup l&ouml;schen: " }
          } + 
          cgi.td( "WIDTH" => "200") { 
            cgi.popup_menu( "NAME" => "file", "VALUES" => config_files) 
          } + 
          cgi.td { 
            cgi.submit( "Loeschen", "delete")
          }
        }
      }

    }
    
    return output
  end

end






