#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2011 by Michael Conrad <do5mc at aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'
require 'aprs4r/APRS4RBase'

require 'aprs4r-web/APRS4RWebBase'

require 'aprs4r-web/AbstractHandler'

include APRS4R


class AdminHandler < AbstractHandler

  @logger = APRS4RLogger.get_logger( "AdminHandler")


  def AdminHandler.header
    return "Admin"
  end


  def AdminHandler.handle_request( cgi)

    auth_file = ENV['APRS4R_WEB_AUTH'] || "/etc/aprs4r-web/lighttpd.auth"
    # logger.debug( "auth_file: #{auth_file}")

    password_status = "nicht gesetzt"
    begin
      File.new( auth_file).each{ |line|
        if line =~ /^aprs4r/
          values = line.split( /:/)

          password_status = "gesetzt" if values.length == 2
        end
      }
    rescue Exception => ex
      # logger.warn( "auth_file: #{ex}")
    end


    version_aprs4r = APRS4RVersion
    version_aprs4r_web = APRS4RWebVersion
    version_aprs4web = "unbekannt"

    output = ""
    output += cgi.h2 { "APRS4R-Admin" }

    output += cgi.table { 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "Passwort: " }
        } + 
        cgi.td( "WIDTH" => "200") {
          cgi.big { password_status } 
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "APRS4R-Version: " }
        } + 
        cgi.td( "WIDTH" => "200") {
          cgi.big { version_aprs4r }
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "25") { 
          cgi.big { "APRS4R-Web-Version: " }
        } + 
        cgi.td( "WIDTH" => "200") {
          cgi.big { version_aprs4r_web } 
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "APRS4WEB-Version: " }
        } + 
        cgi.td( "WIDTH" => "200") {
          cgi.big { version_aprs4web } 
        } 
      }
    }

    return output
  end

end



