#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2011 by Michael Conrad <do5mc at aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

include APRS4R


class APRS4WEBSetupHandler

  @@logger = APRS4RLogger.get_logger( "APRS4WEBSetupHandler")


  def APRS4WEBSetupHandler.header
    return "Setup"
  end


  def APRS4WEBSetupHandler.cgi_parameter( cgi, name)
    value = nil

    parameter = cgi.params[name]
    
    if parameter 
      value = parameter[0]
    end

    return value
  end


  def APRS4WEBSetupHandler.handle_request( cgi)
    @@logger.info( "handle_request( cgi)")

    etc_dir = ENV['APRS4WEB_ETC'] || "/etc/aprs4web"
    @@logger.debug( "etc_dir: #{etc_dir}")

    # default settings
    google_key = "this is my google api key"
    my_latitude = 49.00
    my_longitude = 8.25

    # 
    begin
      File.open( etc_dir + "/" + "aprs4web.js").each{ |line|

        # parse google key
        if line =~ /var google_key = \"[^\"]+\";/
          google_key = /var google_key = \"([^\"]+)\";/.match( line)[1]
        elsif line =~ /var my_latitude = [0-9\.]+;/
          my_latitude = /var my_latitude = ([0-9\.]+);/.match( line)[1]
        elsif line =~ /var my_longitude = [0-9\.]+;/
          my_longitude = /var my_longitude = ([0-9\.]+);/.match( line)[1]
        end
      }
    rescue Exception => ex
      @@logger.error( "Error reading #{etc_dir}/aprs4web.js: #{ex.to_s}")
    end

    action = "unknown"
    action = "save" if cgi_parameter( cgi, 'save')

    result = nil
    
    @@logger.debug( "action: #{action}")
    
    if action == "save"
      @@logger.debug( "save command")
      
      google_key = cgi_parameter( cgi, "google_key")
      my_latitude = cgi_parameter( cgi, "my_latitude")
      my_longitude = cgi_parameter( cgi, "my_longitude")

      # save parameters 
      # TODO: escaping of parameters (injection attack)
      begin
        File.open( etc_dir + "/" + "aprs4web.js", "w") { |file|
          file.puts( "var google_key = \"#{google_key}\";\n")
          file.puts( "var my_latitude = #{my_latitude.to_s};\n")
          file.puts( "var my_longitude = #{my_longitude.to_s};\n")
        }
      rescue Exception => ex
        @@logger.error( "Error writing #{etc_dir}/aprs4web.js: #{ex.to_s}")
      end
    end


    output = "" 

    # manual start/stop
    output += cgi.h2 { "Einstellungen" } 

    output += cgi.table { 
      cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/aprs4web-setup") { 

        cgi.tr { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Google Maps API" } 
          } + 
          cgi.td { } 
        } + 

        cgi.tr { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Schl&uuml;ssel: " } 
          } + 
          cgi.td( "WIDTH" => "200") { 
            cgi.text_field( "google_key", google_key.to_s, 40)
          } 
        } + 

        cgi.tr { 
          cgi.td( "COLSPAN" => "2") { 
            "Zur Benutzung von APRS4WEB ist ein Google Account sowie ein Schl&uuml;ssel f&uuml;r das Google Maps API notwendig. Beides erh&auml;lt man auf folgender Webseite: " + 
            cgi.a( "http://code.google.com/apis/maps/signup.html") { "http://code.google.com/apis/maps/signup.html" } + cgi.br + cgi.br + 

            "Die URL f&uuml;r den der Schl&uuml;ssel erzeugt wird, sollte wie folgt aussehen: " + 
            cgi.b { "http://NAME_ODER_IP_ROUTER/aprs4web/" } + cgi.br + cgi.br +
            "Wird DynDns oder &auml;hnliches benutzt kann auch der DNS-Name verwendet werden, z.B. http://meinRouter.dyndns.org/aprs4web."
          }
        } + 

        cgi.tr { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Meine Position" }
          } + 
          cgi.td { } 
        } + 

        cgi.tr { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Breite: " } 
          } + 
          cgi.td( "WIDTH" => "200") { 
            cgi.text_field( "my_latitude", my_latitude.to_s, 20)
          } 
        } + 

        cgi.tr { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "L&auml;nge: " } 
          } + 
          cgi.td( "WIDTH" => "200") { 
            cgi.text_field( "my_longitude", my_longitude.to_s, 20)
          } 
        } + 

        cgi.tr { 
          cgi.td( "WIDTH" => "200") { } + 
          cgi.td { 
            cgi.submit( "VALUE" => "Speichern", "NAME" => "save")
          }
        }
      }
    }
    
    return output
  end

end

