
require 'cgi'

require 'aprs4r/APRS4RLogger'
include APRS4R

begin
  log4r_name = ENV['APRS4R_WEB_LOG4R'] || "/etc/aprs4r-web/aprs4r-web.log4r"
  APRS4RLogger.load_yaml_file( log4r_name)
rescue Exception => ex
  printf( $stderr, "Error loading log4r configuration: #{log4r_name}, ex: #{ex}\n")
  exit 8
end

@@logger = APRS4RLogger.get_logger( "download")


def handle_request( cgi, session)

  dir = cgi['dir']

  if !File.directory?( dir) 
    output = "Content-Type: text/plain"
    output += "\n\n"
    output += "parameter dir (#{dir}) is no directory\n"
    output += "\n"
  end


  name = cgi['file']
  name = File.basename( name) if name

  file = dir + "/" + name

  if !File.file?( file)
    output = "Content-Type: text/plain"
    output += "\n\n"
    output += "parameter file (#{file}) is no file\n"
    output += "\n"
  end

  output = "" 
  if file 
    output = "Content-Disposition: attachment; filename=#{name}"
    output += "\n\n"

    begin 
      File.open( file).each { |line|
        output += line
      }
    rescue Exception => ex
      output = "Content-Type: text/plain"
      output += "\n\n"
      output += "Error: #{ex}\n"
    end
  else
    output = "Content-Type: text/plain"
    output += "\n\n"

    output += "File #{file} not found..."
  end

  return output
end

cgi = CGI.new( "html4")

print handle_request( cgi, nil)
