
require 'ftools'

require 'aprs4r/APRS4RLogger'
require 'aprs4r/APRS4RConfiguration'

require 'aprs4r-web/AbstractHandler'

include APRS4R


class SetupHandler < AbstractHandler

  @@logger = APRS4RLogger.get_logger( "setup")


  def SetupHandler.header
    return "Setup"
  end


  def SetupHandler.handle_request( cgi)
    @@logger.info( "handle_request( cgi)")

    etc_dir = ENV['APRS4R_ETC'] || "/etc/aprs4r"
    @@logger.debug( "etc_dir: #{etc_dir}")

    session = load_session

    action = "unknown"
    action = "load" if cgi_parameter( cgi, 'load')
    action = "save" if cgi_parameter( cgi, 'save')
    action = "new" if cgi_parameter( cgi, 'new')

    @@logger.debug( "action: #{action}")

    config_file = nil

    if action == "load" 
      @@logger.debug( "load action")

      file = cgi_parameter( cgi, 'file')
      config_file = File.basename( file) if file
      @@logger.debug( "config_file: #{config_file}")

      if !config_file.nil? && !config_file.empty?
        configuration = APRS4RConfiguration.load_configuration( etc_dir + "/" + config_file)

        session['config'] = configuration
        session['file'] = config_file
        session['timestamp'] = Time.now
        session['changed'] = false
      end
    elsif action == "save" 
      @@logger.debug( "save action")

      file = cgi_parameter( cgi, 'file')
      config_file = File.basename( file) if file
      @@logger.debug( "config_file: #{config_file}")

      configuration = session['config']

      if !config_file.nil? && !config_file.empty?
        APRS4RConfiguration.save_configuration( etc_dir + "/" + config_file, configuration)
        
        session['file'] = nil
        session['config'] = nil
        session['timestamp'] = Time.now
        session['changed'] = false
      end

    elsif action == "new"
      @@logger.debug( "new action")

      file = cgi_parameter( cgi, 'file')
      config_file = File.basename( file) if file
      @@logger.debug( "config_file: #{config_file}")

      if !config_file.nil? && !config_file.empty?
        configuration = APRS4RConfiguration.load_configuration( etc_dir + "/templates/" + config_file)

        session['config'] = configuration
        session['file'] = config_file
        session['timestamp'] = Time.now
        session['changed'] = false
      end
    elsif action == "unknown"
      config_file = session['file']
    end

    save_session( session)

    output = "" 
    config_files = Array.new

    if config_file.nil? || config_file.empty?
      config_files << ["", "keine Auswahl", true]
    else
      config_files << ["", "keine Auswahl"]
    end

    Dir.new( etc_dir).sort.each { |name|
      
      if name =~ /\.yaml$/ && name != "default.yaml"

        if config_file == name
          config_files << [name, name, true]
        else 
          config_files << [name, name]
        end
      end
    }

    if config_file.nil? || config_file.empty?
      # config_file = "nicht ausgewhlt"
    end


    template_files = Array.new

    Dir.new( etc_dir + "/" + "templates").sort.each { |name|
      if name =~ /\.yaml$/
        template_files << [name, name]
      end
    }


    output += show_profile( cgi, session)

    output += show_changed( cgi, session)

    output += cgi.h2 { "Profil laden/speichern/neu anlegen" }

    output += cgi.table { 
      
      # load exiting file 
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/setup") { 
          cgi.td( "ALIGN" => "left") { 
            cgi.big { cgi.big { "Profil laden: " } }
          } + 
          cgi.td { 
            cgi.popup_menu( "NAME" => "file", "VALUES" => config_files) 
          } + 
          cgi.td { 
            cgi.submit( "Laden", "load")
          }
        }
      } + 
      
      # save exisiting file 
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/setup") { 
          cgi.td( "ALIGN" => "left") { 
            cgi.big { cgi.big { "Profil speichern: " } }
          } + 
          cgi.td { 
            cgi.text_field( "file", config_file, 20)
          } +
          cgi.td { 
            cgi.submit( "Speichern", "save")
          } 
        }
      } + 
      
      # create new file
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/setup") { 
          cgi.td( "ALIGN" => "left") { 
            cgi.big { cgi.big { "Profil anlegen: " } }
          } + 
          cgi.td { 
            cgi.popup_menu( "NAME" => "file", "VALUES" => template_files) 
          } +
          cgi.td { 
            cgi.submit( "Neu", "new") 
          }
        }
      }

    }
    
    return output
  end

end




