
require 'aprs4r/APRS4RLogger'

include APRS4R


class ProfileStatusHandler

  @logger = APRS4RLogger.get_logger( "ProfileStatusHandler")


  def ProfileStatusHandler.header
    return "Status - Profile"
  end


  def ProfileStatusHandler.cgi_parameter( cgi, name)
    value = nil

    parameter = cgi.params[name]
    
    if parameter 
      value = parameter[0]
    end

    return value
  end


  def ProfileStatusHandler.handle_request( cgi)
    @@logger.info( "handle_request( cgi)")

    etc_dir = ENV['APRS4R_ETC'] || "/etc/aprs4r"
    @@logger.debug( "etc_dir: #{etc_dir}")

    action = "unknown"
    # action = "export" if cgi_parameter( cgi, 'export') # export will be handled by external download servlet
    action = "import" if cgi_parameter( cgi, 'import')
    action = "delete" if cgi_parameter( cgi, 'delete')

    @@logger.debug( "action: #{action}")

    config_file = nil

    if action == "export"
      # this action is handled by download servlet
    elsif action == "import"
      upload = cgi_parameter( cgi, 'file')

      @@logger.debug( "upload.class: #{upload.class}")
      @@logger.debug( "upload.local_path: #{upload.local_path}")
      @@logger.debug( "upload.original_filename: #{upload.original_filename}")
      
      if !upload.nil? && (upload.length > 0)
        begin
          config_file = File.basename( upload.original_filename) if upload.original_filename

          if !config_file.nil?
            File.open( etc_dir + "/" + config_file, "w") { |file|
              file.puts( upload.read)
            }
          end

        rescue Exception => ex
          @@logger.warn( "Error importing file: #{config_file}, ex: #{ex}")
        end
      end
    elsif action == "delete"
      file = cgi_parameter( cgi, 'file')
      config_file = File.basename( file) if file

      begin
        File.delete( etc_dir + "/" + config_file)
      rescue Exception => ex
        @@logger.warn( "Error deleting file: #{config_file}, ex: #{ex}")
      end
    end


    output = "" 
    config_files = Array.new

    if config_file.nil? || config_file.empty?
      config_files << ["keine Auswahl", "keine Auswahl", true]
    else
      config_files << ["keine Auswahl", "keine Auswahl"]
    end

    Dir.new( etc_dir).sort.each { |name|
      
      if name =~ /\.yaml$/ && name != "default.yaml"

        if config_file == name
          config_files << [name, name, true]
        else 
          config_files << [name, name]
        end
      end
    }

    if config_file.nil? || config_file.empty?
      config_file = "nicht ausgewaehlt"
    end

    output = cgi.h2 { "Profil exportieren/importieren" } 

    output += cgi.table { 
      
      # export existing file
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/download.rb") { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Profil exportieren: " }
          } + 
          cgi.td( "WIDTH" => "200") {
            cgi.hidden( "dir", etc_dir) + 
            cgi.popup_menu( "NAME" => "file", "VALUES" => config_files) 
          } + 
          cgi.td { 
            cgi.submit( "Export", "export")
          }
        }
      } + 

      # import new file
      cgi.tr { 
        cgi.multipart_form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/status/profile") { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Profil importieren: " }
          } + 
          cgi.td( "WIDTH" => "200") { 
            cgi.file_field( "file", 20)
          } + 
          cgi.td { 
            cgi.submit( "Import", "import")
          }
        }
      } + 

      # delete existing file
      cgi.tr { 
        cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/status/profile") { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Profil lschen: " }
          } + 
          cgi.td( "WIDTH" => "200") { 
            cgi.popup_menu( "NAME" => "file", "VALUES" => config_files) 
          } + 
          cgi.td { 
            cgi.submit( "Lschen", "delete")
          }
        }
      }

    }
    
    return output
  end

end






