
require 'cgi'

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRS4RConfiguration'
require 'aprs4r/ConfigurationAttribute'

require 'aprs4r/SocketConfiguration'
require 'aprs4r/AX25SocketConfiguration'
require 'aprs4r/ISSocketConfiguration'

require 'aprs4r-web/AbstractHandler'

include APRS4R


class DeviceSetupHandler < AbstractHandler

  @logger = APRS4RLogger.get_logger( "DeviceSetupHandler")


  def DeviceSetupHandler.header
    return "Setup - Schnittstellen (AX25, Internet)"
  end

  def DeviceSetupHandler.handle_request( cgi)

    # configuration = load_configuration( session)

    session = load_session 

    configuration = nil
    configuration = session['config'] if session

    return show_timeout( cgi) if configuration.nil?
    
    if configuration.devices.nil?
      configuration.devices = Hash.new
    end

    devices = configuration.devices


    action = handle_input( cgi, session, devices, "device", SocketConfiguration.subtypes, "device")
    
    if action == "new" || action == "update" || action == "delete" 
      session['config'] = configuration
      session['changed'] = true
      session['timestamp'] = Time.now
      save_session( session)
    end

    output = "" 
    
    output += show_profile( cgi, session)

    output += show_changed( cgi, session)

    output += create_output( cgi, "Schnittstellen", configuration.devices, "Schnittstelle", SocketConfiguration.subtypes, "/aprs4r-web/cgi-bin/admin.rb/setup/devices")

    return output 
  end

end



