
require 'cgi'
require 'yaml'

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRS4RConfiguration'

require 'aprs4r-web/AbstractHandler'

include APRS4R


class EditorSetupHandler < AbstractHandler

  @logger = APRS4RLogger.get_logger( "EditorSetupHandler")


  def EditorSetupHandler.header
    return "Setup - Editor"
  end

  def EditorSetupHandler.handle_request( cgi)

    # configuration = load_configuration( session)

    session = load_session 

    configuration = nil
    configuration = session['config'] if session

    return show_timeout( cgi) if configuration.nil?

    action = "show"
    action = "update" if cgi_parameter( cgi, "update")

    if action == "update"
      
      configuration_text = cgi_parameter( cgi, "editor")
      @logger.error( "configuration_text: #{configuration_text}")

      configuration = YAML.load( configuration_text)
      @logger.error( "configuration: #{configuration}")

      session['config'] = configuration
      session['changed'] = true
      session['timestamp'] = Time.now
      save_session( session)
    end
    
    
    output = "" 
    
    output += show_profile( cgi, session)

    output += show_changed( cgi, session)

    output += cgi.h2 { "Editor - Benutzung auf eigene Gefahr" }

    configuration_text = YAML::dump( configuration)

    output += cgi.table {
      
      cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/setup/editor") {
        # save existing file
        cgi.tr {
          cgi.td( "ALIGN" => "left") { 
            cgi.big { cgi.big { "&Auml;nderungen &uuml;bernehmen: " } }
          } + 
          cgi.td { 
            cgi.submit( "Uebernehmen", "update")
          }
        } + 
        cgi.textarea( "editor", 80, 30) { configuration_text }
      }
    }

    return output 
  end

end



