
require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRS4RVersion'
require 'aprs4r-web/APRS4RWebVersion'

include APRS4R


class StatusHandler

  @logger = APRS4RLogger.get_logger( "StatusHandler")


  def StatusHandler.header
    return "Status"
  end


  def StatusHandler.handle_request( cgi)
    # logger.info( "handle_request( cgi)")

    default_file = ENV['APRS4R_DEFAULT'] || "/etc/default/aprs4r"
    # logger.debug( "default_file: #{default_file}")

    pid_file = ENV['APRS4R_PID'] || "/var/run/aprs4r.pid"
    # logger.debug( "pid_file: #{pid_file}")
    
    log_dir = ENV['APRS4R_LOG'] || "/var/log/aprs4r"
    # logger.debug( "log_dir: #{log_dir}")
    
    output = "" 
    

    # read default file
    start_boot = false
    begin
      File.new( default_file).each{ |line|
        if line =~ /START_DAEMON/ && (line =~ /true/ || line =~ /TRUE/)
          start_boot = true
        end
      }
    rescue Exception
    end
    
    start_profile = ""
    begin
      File.new( default_file).each{ |line|
        if line =~ /PROFILE/
          start_profile = line.chomp!.split( /\=/)[1]
          start_profile.gsub!( /\"/, "")
        end
      }
    rescue Exception
    end


    # check process
    pid = -1
    
    begin 
      File.open( pid_file).each { |line|
        pid = line.chomp!.to_i if line && line =~ /^[0-9]*$/
      }
    rescue Exception
    end
    
    # logger.debug( "pid: #{pid}")
    
    pid_result = -1
    
    if pid > 0 
      begin
        pid_result = Process.kill( 0, pid)
      rescue Exception
      end
    end

    pid_status = "nicht aktiv"
    if pid_result != -1 
      pid_status = "aktiv (PID #{pid})"
    end
    
    # print out process status
    output += cgi.h2 { "APRS4R-Status" } 

    output += cgi.table { 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "Software: " }
        } + 
        cgi.td( "WIDTH" => "500") {
          cgi.big { pid_status } 
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "APRS4R-Version: " }
        } + 
        cgi.td( "WIDTH" => "500") {
          output = cgi.big { "#{APRS4RVersion} (Build #{APRS4RBuild}) " } 
          output += cgi.big( "STYLE" => "color:red") { " (Release Candidate)" } if APRS4RRC == true

          output
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "APRS4R-Datum: " }
        } + 
        cgi.td( "WIDTH" => "500") {
          cgi.big { "#{APRS4RDate.join( '-')}" } 
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "APRS4RWeb-Version: " }
        } + 
        cgi.td( "WIDTH" => "500") {
          output = cgi.big { "#{APRS4RWebVersion} (Build #{APRS4RWebBuild})" } 
          output += cgi.big( "STYLE" => "color:red") { " (Release Candidate)" } if APRS4RWebRC == true
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "APRS4RWeb-Datum: " }
        } + 
        cgi.td( "WIDTH" => "500") {
          cgi.big { "#{APRS4RWebDate.join( '-')}" } 
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "Automatischer Start: " }
        } + 
        cgi.td( "WIDTH" => "500") {
          cgi.big { start_boot ? "ja" : "nein" } 
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "Startprofil: " }
        } + 
        cgi.td( "WIDTH" => "500") {
          cgi.big { start_profile } 
        } 
      }
    }


    # print out log
    log_lines = Array.new
    begin
      File.open( log_dir + "/aprs4r.log").each{ |line|
        log_lines << line.force_encoding( "ASCII-8BIT")
        
        if log_lines.length > 20
          log_lines.shift
        end
      }
    rescue Exception
    end
    
    output += cgi.h2 { "APRS4R-Log" } 

    if log_lines.length > 0 
      output += cgi.small { cgi.small { cgi.pre { log_lines.join( "") } } }
    else
      output += cgi.p { "Keine Daten in #{log_dir}/aprs4r.log gefunden" }
    end

    return output
  end
  
end


