
require 'cgi'

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRS4RConfiguration'
require 'aprs4r/ConfigurationAttribute'

require 'aprs4r/PluginConfiguration'
require 'aprs4r/ISServerPluginConfiguration'

require 'aprs4r-web/AbstractHandler'

include APRS4R


class MiscSetupHandler < AbstractHandler

  @@logger = APRS4RLogger.get_logger( "MiscSetupHandler")


  def MiscSetupHandler.header
    return "Setup - Weitere Module"
  end


  def MiscSetupHandler.handle_request( cgi)
    @@logger.info( "handle_request( cgi)")

    session = load_session

    configuration = nil
    configuration = session['config'] if session

    if configuration.nil?
      return cgi.h3( "ALIGN" => "center", "STYLE" => "color:red") { 
        "Kein Profil geladen oder Zeit&uuml;berschreitung!" + 
        cgi.a( "/aprs4r-web/cgi-bin/admin.rb/setup") { "Hier laden." }
      } 
    end

    return show_timeout( cgi) if configuration.nil?

    if configuration.plugins.nil?
      configuration.plugins = Hash.new
    end

    plugins = configuration.plugins

    # filter out beacons
    beacons = Hash.new

    if plugins && ! plugins.empty?
      plugins.each{ |id, plugin|
        @@logger.debug( "plugin: #{plugin}, class: #{plugin.class}")
        if plugin.type !~ /(Beacon|Gateway|Digipeater|Weather)Plugin/
          beacons[id] = plugin
          plugins.delete( id)
        end
      }
    end

    beacon_types = Array.new
    PluginConfiguration.subtypes.each{ |type|
      if type !~ /(Beacon|Gateway|Digipeater|Weather)Plugin/
        beacon_types << type
      end
    }

    # process input
    action = handle_input( cgi, session, beacons, "plugin", beacon_types, "misc")

    if beacons && ! beacons.empty? 
      beacons.each{ |id, plugin| 
        plugins[id] = plugin
      }
    end


    if action == "new" || action == "update" || action == "delete"
      session['config'] = configuration 
      session['changed'] = true
      session['timestamp'] = Time.now
      save_session( session)
    end

    # generate html output
    output = "" 

    output += show_profile( cgi, session)

    output += show_changed( cgi, session)

    output += create_output( cgi, "Weitere Module", beacons, "Module", beacon_types, "/aprs4r-web/cgi-bin/admin.rb/setup/misc")

    return output 
  end

end


