
require 'cgi'

require 'aprs4r/APRS4RLogger'
include APRS4R

begin
  log4r_name = ENV['APRS4R_WEB_LOG4R'] || "/etc/aprs4r-web/aprs4r-web.log4r"
  APRS4RLogger.load_yaml_file( log4r_name)
rescue Exception => ex
  printf( $stderr, "Error loading log4r configuration: #{log4r_name}, ex: #{ex}\n")
  exit 8
end

@@logger = APRS4RLogger.get_logger( "admin")

@@menu = [
          [ "APRS4R" ], 
          [ "Status", "status", true, "StatusHandler"],
          [ "Startup", "status/startup", false, "StartupStatusHandler"],
          [ "Profile", "status/profile", false, "ProfileStatusHandler"],
          [ "Backup", "status/backup", false, "BackupStatusHandler"],
          [ "Log", "status/log", false, "LogStatusHandler"],
          [ "Debug", "status/debug", false, "DebugStatusHandler"],
          
          [ "Setup", "setup", true, "SetupHandler"], 
          [ "Devices", "setup/devices", false, "DeviceSetupHandler"], 
          [ "Beacons", "setup/beacons", false, "BeaconSetupHandler"],
          [ "Digipeater", "setup/digipeater", false, "DigipeaterSetupHandler"], 
          [ "Weather", "setup/weather", false, "WeatherSetupHandler"],
          [ "Misc", "setup/misc", false, "MiscSetupHandler"],
          [ "Editor", "setup/editor", false, "EditorSetupHandler"], 
          
          [ "Admin", "admin", true, "AdminHandler"], 
          [ "Password", "admin/password", false, "PasswordAdminHandler"],
          [ "Update", "admin/update", false, "UpdateAdminHandler"],
          
          [ "APRS4WEB" ],
          [ "Setup", "aprs4web-setup", true, "APRS4WEBSetupHandler"]
         ]


def handle_error( cgi, exception)

  output = ""

  output += cgi.h2 { "APRS4R-Fehler/Error" } 

  output += cgi.p { "Es ist ein Fehler aufgetreten. Bitte keine Umlaute oder Sonderzeichen verwenden. " }
  output += cgi.p { "An error has occurred, please do not use umlauts or other non-ascii characters. " }
  
  output += cgi.h3 { "Fehlerausgabe" }
  
  if exception.nil?
    output += cgi.small { cgi.small { "nicht verf&uuml;gbar" } }
  else
    output += cgi.small { cgi.small { cgi.pre { exception.backtrace.join( "\n") } } }
  end

  output
end


def handle_request( cgi, error, exception)

  query_string = ENV['QUERY_STRING']
  script_name = ENV['SCRIPT_NAME']
  path_info = ENV['PATH_INFO']

  @@logger.debug( "query_string: #{query_string}")
  @@logger.debug( "script_name: #{script_name}")
  @@logger.debug( "path_info: #{path_info}")

  script_file = path_info
  
  if script_file == nil || script_file.empty?
    script_file = "/status"
  end
  
  @@logger.debug( "script_file: #{script_file}")
  
  handler = nil
  
  if script_file != nil && script_file != ""
    script_file = script_file[1..script_file.length]
    
    @@logger.debug( "script_file: #{script_file}")
    
    @@menu.each{ |entry|

      if entry.length == 4 && entry[1] == script_file
        require "aprs4r-web/#{entry[3]}"
        handler = eval( entry[3])
      end
    }
    
    @@logger.debug( "handler: #{handler}")
  end
  
  header_line = "ARPRS4R Webinterface"
  header_line = handler.header if handler
    
  output = cgi.html { 
    
    cgi.head { 
      cgi.title{ "APRS4R Configuration Pages" } + 
      "<link rel=\"icon\" href=\"/aprs4r-web/images/aprs4r-logo.ico\" type=\"image/x-icon\"/>
         <link rel=\"shortcut icon\" href=\"/aprs4r-web/images/aprs4r-logo.ico\" type=\"image/x-icon\"/>"
    } + 
    
    cgi.body { 
      
      "<script type=\"text/javascript\">
         document.name = \"main\"
         function markAndOpen( currentNode, name) {
           currentNode.parentNode.setAttribute( \"id\", \"edit\");
           sub_window = window.open( currentNode.href, name, \"width=600,height=500,left=100,top=200\");
           sub_window.focus();
         }
       </script>" + 
      
      cgi.table { 
        
        # title row
        cgi.tr { 
          # upper left corner (logo)
          cgi.td( "WIDTH" => "20%") { cgi.img( "/aprs4r-web/images/aprs4r-logo.png", "aprs4r logo", 150) } + 
          
          # upper right corner (logo)
          # cgi.td( "WIDTH" => "80%", "ALIGN" => "left") { cgi.h1 { "&nbsp;" + "&nbsp;" + header_line } }
          cgi.td( "ALIGN" => "left", "WIDTH" => "800") { cgi.h1 { "&nbsp;" + "&nbsp;" + header_line } }
        } + 
        
        # main row
        cgi.tr { 
          # navigation column
          cgi.td( "HEIGHT" => "80%", "VALIGN" => "TOP") { 
            
            output = ""
            @@menu.each{ |entry|
              
              if entry.length == 4
                
                if entry[2] == true 
                  # top level entry
                  output += cgi.a( "/aprs4r-web/cgi-bin/admin.rb/#{entry[1]}" ) { cgi.big { entry[0] } } + cgi.br
                else 
                  # sub level entry
                  output += cgi.a( "/aprs4r-web/cgi-bin/admin.rb/#{entry[1]}") { cgi.small { entry[0] } } + cgi.br
                end
                
              elsif entry.length == 1 
                output += cgi.br 
                output += cgi.big { cgi.big { entry[0] } } + cgi.br
              end
            }
            
            output
          } + 
          
          cgi.td( "ALIGN" => "left", "VALIGN" => "top", "WIDTH" => "800") { 
            if handler 

              if error 
                output = handle_error( cgi, exception)
              else
                begin
                  output = handler.handle_request( cgi)
                rescue Exeption => ex
                  output = handle_error( cgi, ex)
                end
              end
            else
              output = "test"
            end
            
            output
          } 
        }
      }
    }
  }
  
  return output
end

# main loop
cgi = nil

begin
  begin 
    cgi = CGI.new( "html4")
    
    cgi.out { 
      handle_request( cgi, false, nil)
    }
  rescue Exception => ex
    ENV['REQUEST_METHOD'] = ""
    cgi = CGI.new( "html4")
    
    cgi.out { 
      handle_request( cgi, true, ex)
    }
  end
rescue Exception => ex
  puts "<h1>ERROR</h1>"
  puts "<pre>"
  ex.backtrace.join( '\n')
  puts "</pre>"
end


