
require 'aprs4r/APRS4RLogger'

require 'aprs4r-web/AbstractHandler'

include APRS4R


class PasswordAdminHandler < AbstractHandler

  @@logger = APRS4RLogger.get_logger( "PasswordAdminHandler")


  def PasswordAdminHandler.header
    return "Admin - Passwort"
  end


  def PasswordAdminHandler.cgi_parameter( cgi, name)
    value = nil
    
    parameter = cgi.params[name]
    value = parameter[0] if parameter

    return value
  end


  def PasswordAdminHandler.handle_request( cgi)

    auth_file = ENV['APRS4R_WEB_AUTH'] || "/etc/aprs4r-web/lighttpd.auth"
    # logger.debug( "auth_file: #{auth_file}")

    action = "unknown"
    action = "update" if cgi_parameter( cgi, 'update')

    if action == "update"

      password = cgi_parameter( cgi, 'password')

      begin
        File.open( auth_file, "w") { |file|

          if !password.nil? && !password.empty?
            file.puts( "aprs4r:#{password}")
          else
            file.puts( "aprs4r:")
          end
        }
      rescue Exception => ex
        @@logger.warn( "auth_file: #{ex}")
      end
    end


    password_status = "nicht gesetzt"
    begin
      File.new( auth_file).each{ |line|
        if line =~ /^aprs4r/
          values = line.split( /:/)
          
          password_status = "gesetzt" if values.length == 2
        end
      }
    rescue Exception => ex
      # logger.warn( "auth_file: #{ex}")
    end


    output = "" 

    output += cgi.h2 { "APRS4R Web Passwort" }

    output += cgi.table { 
      cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/admin/password") { 
        
        cgi.tr { 
          cgi.td( "WIDTH" => "200", "ALIGN" => "left") { 
            cgi.big { "Passwort setzen: " }
          } + 
          cgi.td { 
            cgi.text_field( "password", "", 20)
          } + 
          cgi.td { 
            cgi.submit( "Neu setzen", "update")
          } 
        }
      }

    } 
     
    output += cgi.p { 
      cgi.big { "Achtung: "} + 
      "Mit dem Neusetzen des Web-Passwortes ist dies sofort g&uuml;tig !"
    }
    
    return output
  end

end



