
require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRS4RConfiguration'
require 'aprs4r/ConfigurationAttribute'

require 'aprs4r/PluginConfiguration'
require 'aprs4r/BeaconPluginConfiguration'

require 'aprs4r-web/AbstractHandler'

include APRS4R

# Frank (newgods.org): /^(?!xxx)$/
# Frank (newgods.org): wobei xxx deine orginal regex ist
# hoogla: was machen die ?!
# 
# - 10:46 -
# Frank (newgods.org): negated lookahead

class BeaconSetupHandler < AbstractHandler

  @@logger = APRS4RLogger.get_logger( "BeaconSetupHandler")


  def BeaconSetupHandler.header
    return "Setup - Baken"
  end


  def BeaconSetupHandler.handle_request( cgi)
    @@logger.info( "handle_request( cgi)")

    session = load_session

    configuration = nil
    configuration = session['config'] if session

    return show_timeout( cgi) if configuration.nil?

    if configuration.plugins.nil?
      configuration.plugins = Hash.new
    end

    plugins = configuration.plugins

    # filter out beacons
    beacons = Hash.new

    if plugins && ! plugins.empty?
      plugins.each{ |id, plugin|
        @@logger.debug( "plugin: #{plugin}, class: #{plugin.class}")
        if plugin.type =~ /BeaconPlugin$/
          beacons[id] = plugin
          plugins.delete( id)
        end
      }
    end

    beacon_types = Array.new
    PluginConfiguration.subtypes.each{ |type|
      if type =~ /BeaconPlugin/
        beacon_types << type
      end
    }

    # process input
    action = handle_input( cgi, session, beacons, "plugin", beacon_types, "beacon")

    if beacons && !beacons.empty?
      beacons.each{ |id, plugin| 
        plugins[id] = plugin
      }
    end

    
    if action == "new" || action == "update" || action == "delete"
      session['config'] = configuration
      session['changed'] = true
      session['timestamp'] = Time.now
      save_session( session)
    end

    # generate html output
    output = "" 

    output += show_profile( cgi, session)

    output += show_changed( cgi, session)

    output += create_output( cgi, "Baken", beacons, "Bake", beacon_types, "/aprs4r-web/cgi-bin/admin.rb/setup/beacons")

    return output 
  end

end


