
require 'aprs4r/APRS4RLogger'
require 'aprs4r/APRS4RBase'

require 'aprs4r-web/APRS4RWebBase'

require 'aprs4r-web/AbstractHandler'

include APRS4R


class AdminHandler < AbstractHandler

  @logger = APRS4RLogger.get_logger( "AdminHandler")


  def AdminHandler.header
    return "Admin"
  end


  def AdminHandler.handle_request( cgi)

    auth_file = ENV['APRS4R_WEB_AUTH'] || "/etc/aprs4r-web/lighttpd.auth"
    # logger.debug( "auth_file: #{auth_file}")

    password_status = "nicht gesetzt"
    begin
      File.new( auth_file).each{ |line|
        if line =~ /^aprs4r/
          values = line.split( /:/)

          password_status = "gesetzt" if values.length == 2
        end
      }
    rescue Exception => ex
      # logger.warn( "auth_file: #{ex}")
    end


    version_aprs4r = APRS4RVersion
    version_aprs4r_web = APRS4RWebVersion
    version_aprs4web = "unbekannt"

    output = ""
    output += cgi.h2 { "APRS4R-Admin" }

    output += cgi.table { 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "Passwort: " }
        } + 
        cgi.td( "WIDTH" => "200") {
          cgi.big { password_status } 
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "APRS4R-Version: " }
        } + 
        cgi.td( "WIDTH" => "200") {
          cgi.big { version_aprs4r }
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "25") { 
          cgi.big { "APRS4R-Web-Version: " }
        } + 
        cgi.td( "WIDTH" => "200") {
          cgi.big { version_aprs4r_web } 
        } 
      } + 
      cgi.tr { 
        cgi.td( "WIDTH" => "250") { 
          cgi.big { "APRS4WEB-Version: " }
        } + 
        cgi.td( "WIDTH" => "200") {
          cgi.big { version_aprs4web } 
        } 
      }
    }

    return output
  end

end



