
require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRS4RConfiguration'

require 'aprs4r/APRSCall'

require 'aprs4r/SocketConfiguration'
require 'aprs4r/ISSocketConfiguration'
require 'aprs4r/AX25SocketConfiguration'

require 'aprs4r/PluginConfiguration'
require 'aprs4r/BeaconPluginConfiguration'
require 'aprs4r/ProportionalBeaconPluginConfiguration'
require 'aprs4r/StatusBeaconPluginConfiguration'
require 'aprs4r/WeatherBeaconPluginConfiguration'
require 'aprs4r/GatewayPluginConfiguration'
require 'aprs4r/DigipeaterPluginConfiguration'
require 'aprs4r/LCD4LinuxPluginConfiguration'
require 'aprs4r/XMLDataPluginConfiguration'
require 'aprs4r/QueryPluginConfiguration'
require 'aprs4r/MessagePluginConfiguration'
require 'aprs4r/ISServerPluginConfiguration'
require 'aprs4r/WeatherPluginConfiguration'
require 'aprs4r/WMRWeatherPluginConfiguration'
require 'aprs4r/UltimeterWeatherPluginConfiguration'
require 'aprs4r/WM918WeatherPluginConfiguration'
require 'aprs4r/LogPluginConfiguration'


include APRS4R


class AbstractHandler

  @@logger = APRS4RLogger.get_logger( "AbstractHandler")

  def AbstractHandler.cgi_parameter( cgi, name)
    value = nil

    parameter = cgi.params[name]
    
    if parameter 
      value = parameter[0]
    end

    return value
  end

  
  def AbstractHandler.show_timeout( cgi)
    @@logger.info( "show_timeout( cgi)")

    return cgi.h3( "ALIGN" => "center", "STYLE" => "color:red") { 
      "Kein Profil geladen oder Zeit&uuml;berschreitung!" + 
      cgi.a( "/aprs4r-web/cgi-bin/admin.rb/setup") { "Hier laden." }
    } 
  end


  def AbstractHandler.show_profile( cgi, session)
    @@logger.info( "show_profile( cgi, session)")

    if session['file']
      return cgi.h3( "ALIGN" => "right") { "Profil: #{session['file']}" }
    end

    return ""
  end


  def AbstractHandler.show_changed( cgi, session)
    @@logger.info( "show_changed( cgi, session)")

    if session['changed']
      return cgi.h3( "ALIGN" => "right", "STYLE" => "color:red") { 
        "Achtung: Profil noch nicht gespeichert !" +
        cgi.a( "/aprs4r-web/cgi-bin/admin.rb/setup") { "Hier speichern." }
      } 
    end

    return ""
  end


  def AbstractHandler.handle_input( cgi, session, items, item_name, item_types, item_prefix)
    @@logger.info( "handle_input( cgi, session, items, item_name, item_types, item_prefix)")
    
    @@logger.debug( "keys: #{cgi.keys.join( ", ")}")

    # remove section
    id = cgi_parameter( cgi, 'id')
    action = "unknown"
    action = "new" if cgi_parameter( cgi, 'new')
    action = "update" if cgi_parameter( cgi, 'update')
    action = "delete" if cgi_parameter( cgi, 'delete')
    
    item = "unknown"
    item = cgi_parameter( cgi, item_name) if cgi_parameter( cgi, item_name)
    
    @@logger.debug( "action: #{action}, item: #{item}")
    
    # process action 
    if action == "new"
      name = cgi_parameter( cgi, 'name')
      type = cgi_parameter( cgi, 'type')
      
      @@logger.debug( "name: #{name}, type: #{type}")
      
      item = nil
      
      if item_types.include?( type)
        item = eval( "#{type}Configuration.new")

        # set default values
        item.attributes.each{ |attribute|
          if attribute.default
            item.instance_variable_set( "@#{attribute.name}", attribute.default)
          end
        }

        # set item parameter
        item.name = name
        item.type = type
        item.enable = false
        item.remote = false

      end
      
      if item 
        id = nil

        if items.length == 0
          id = item_prefix + "00"
        else
          id = items.keys.sort.last.next
        end
        @@logger.debug( "new:id: #{id}")
        @@logger.debug( "items.class: #{items.class}")
        items[id] = item
      end
      
    elsif action == "update"
      
      @@logger.debug( "id: #{id}")
      @@logger.debug( "items: #{items}")
      @@logger.debug( "items.class: #{items.class}")

      handle_update( cgi, session, id, items[id])

    elsif action == "delete"
      items.delete( id)
    end

    return action
  end


  def AbstractHandler.handle_update( cgi, session, id, item)
    @@logger.info( "handle_update( cgi, session, id, item)")

    if item
      @@logger.debug( "item: #{item} #{item.class}")
      attributes = item.attributes
      
      attributes.each{ |attribute|
        
        if attribute.mutable
          name = attribute.name
          field = cgi_parameter( cgi,  id + ":" + name)
          value = nil
          
          @@logger.debug( "attribute: #{name} field: #{field.class}")
          
          if attribute.type == "text"
            value = field.to_s
          elsif attribute.type == "number"
            value = field.to_i
          elsif attribute.type == "float"
            value = field.to_f
          elsif attribute.type == "boolean"
            value = false 
            value = true if field == "true" 
          elsif attribute.type == "array"
            value = Array.new

            if field
              field.split( /,/).each { |entry|
                value << entry.strip
              }
            end
            
          elsif attribute.type == "select"
            value = field.to_s
          elsif attribute.type == "complex"
            value = handle_update( cgi, session, id + ":" + name, attribute.default)
          else 
            @@logger.debug( "Unknown field type #{attribute.type}")
          end
          @@logger.debug( "name: #{name} value: #{value}, value.class: #{value.class}")
          
          item.instance_variable_set( "@#{name}", value)
        end
      }
    end

    return item
  end


  def AbstractHandler.create_output( cgi, title, items, item_title, item_types, item_action)

    output = ""

    output += cgi.h2 { title.to_s } 

    output += cgi.p { 
      
      item_output = ""

      items.each{ |id, item_configuration| 
        
        item_prefix = id + ":" 
        
        item_output += cgi.h3 { "#{item_title}: #{item_configuration.name}" } 
        
        item_output += create_form( cgi, item_configuration, id, item_prefix, item_action, false)
      }
      
      item_output
    } + 
      
      cgi.h2 { "neue #{item_title}" } + 
      
      cgi.form( "ACTION" => item_action) { 
      cgi.table( "BORDER" => "1") { 
        
        cgi.tr { cgi.td( "WIDTH" => "200") { "Name: " } + cgi.td { cgi.text_field( "name") } } + 
        cgi.tr { cgi.td { "Typ: " } + cgi.td { cgi.popup_menu( "NAME" => "type", "VALUES" => item_types) } } + 
        cgi.tr { cgi.td {} + cgi.td { cgi.submit( "Neu", "new") } }
      }
      
    }

    return output
  end


  def AbstractHandler.create_form( cgi, configuration, item_id, item_prefix, item_action, sub_form)
    @@logger.info( "create_form( cgi, configuration, item_id, item_prefix, item_action, sub_form)")

    table_output = cgi.table( "BORDER" => "1") { 
      
      attribute_output = ""
      attributes = configuration.attributes

      @@logger.debug( "configuration: #{configuration}")
      attributes.each{ |attribute|

        @@logger.debug( "attribute: #{attribute.name}")
        @@logger.debug( "deprecated?: #{attribute.deprecated}")
        
        attribute_output += cgi.tr { 
          row_output = "" 

          if attribute.deprecated
            row_output += cgi.td( "WIDTH" => "130", "VALIGN" => "TOP") { "#{attribute.description}*" }
          else
            row_output += cgi.td( "WIDTH" => "130", "VALIGN" => "TOP") { "#{attribute.description}" }
          end
          
          if !attribute.mutable

            text_output = configuration.instance_variable_get( "@#{attribute.name}").to_s

            if attribute.extension
              text_output += cgi.a( "HREF" => attribute.extension, "target" => "_blank") { 
                "Online-Dokumentation" 
              } 
            end

            row_output += cgi.td { 
              text_output
            }

          elsif attribute.type == "text" || attribute.type == "number" || attribute.type == "float"

            value = configuration.instance_variable_get( "@#{attribute.name}")

            text_output = cgi.text_field( item_prefix + attribute.name, value.to_s)

            if attribute.extension
              text_output += cgi.a( "HREF" => attribute.extension, "ONCLICK" => "markAndOpen( this, \"Detail\"); return false;") { "EDIT" }
            end
            
            row_output += cgi.td { 
              text_output
            } 

          elsif attribute.type == "boolean"

            value = configuration.instance_variable_get( "@#{attribute.name}")
            
            if value 
              row_output += cgi.td { 
                cgi.radio_group( item_prefix + attribute.name, ["true", "ja", true], ["false", "nein"]) 
              }
            else
              row_output += cgi.td { 
                cgi.radio_group( item_prefix + attribute.name, ["true", "ja"], ["false", "nein", true]) 
              }
            end

          elsif attribute.type == "array"
            list = ""
            value = configuration.instance_variable_get( "@#{attribute.name}")

            if value.nil? 
              value = Array.new
            end
            
            if value 
              value.each{ |entry|
                list += entry.to_s + ", "
              }
            end
            
            # remove trailing comma and space
            list.chop!
            list.chop!
            
            row_output += cgi.td { cgi.text_field( item_prefix + attribute.name, list) }

          elsif attribute.type == "complex"
            prefix = item_prefix + attribute.name + ":"

            value = configuration.instance_variable_get( "@#{attribute.name}")

            value = attribute.default if value.nil?
            
            if value
              row_output += cgi.td { create_form( cgi, value, item_id, prefix, item_action, true) }
            else
              row_output += cgi.td { "No complex subtype given." }
            end
          else
            row_output += cgi.td { "Unknown field type #{attribute.type}" }
          end
          
          row_output
        }
        
      }
      
      if !sub_form
        attribute_output += cgi.tr { cgi.td { } + cgi.td( "ALIGN" => "right") { 
            cgi.hidden( "id", item_id.to_s) + cgi.hidden( "plugin", configuration.name) + cgi.submit( "Uebernehmen", "update") + cgi.submit( "Loeschen", "delete")
          }
          
        }
      end
      
      attribute_output
    }


    item_output = table_output
    item_output = cgi.form( "ACTION" => item_action) { table_output } if !sub_form

    return item_output
  end


  def AbstractHandler.load_session
    @@logger.info( "load_session")
    
    session = nil

    begin
      session = YAML.load_file( "/tmp/aprs4r-web-session.yaml")
    rescue Exception => ex
      # create new session
      session = Hash.new
    end

    @@logger.debug( "session: #{session.class}, #{session}")

    timestamp = Time.now
    timestamp = session['timestamp'] if session['timestamp']

    if Time.new > (timestamp + 2 * 60 * 60)
      session['config'] = nil
      session['file'] = nil
    end

    return session
  end


  def AbstractHandler.save_session( session)
    @@logger.info( "save_session( session)")

    if session 

      @@logger.debug( "session: #{session.class}, #{session}")

      # session['timestamp'] = Time.now if session['timestamp'].nil?

      begin
        File.open( "/tmp/aprs4r-web-session.yaml", "w") { |file|
          YAML.dump( session, file)
        }
      rescue Exception => ex
        
      end
    end

    return
  end

end
