
require 'aprs4r/APRS4RLogger'

include APRS4R


class StatusHandler

  @logger = APRS4RLogger.get_logger( "StatusHandler")


  def StatusHandler.header
    return "Status"
  end


  def StatusHandler.handle_request( cgi)
    # logger.info( "handle_request( cgi)")

    pid_file = ENV['APRS4R_PID'] || "/var/run/aprs4r.pid"
    # logger.debug( "pid_file: #{pid_file}")
    
    log_dir = ENV['APRS4R_LOG'] || "/var/log/aprs4r"
    # logger.debug( "log_dir: #{log_dir}")
    
    output = "" 
    
    # check process
    pid = -1
    
    begin 
      File.open( pid_file).each { |line|
        pid = line.chomp!.to_i if line && line =~ /^[0-9]*$/
      }
    rescue Exception
    end
    
    # logger.debug( "pid: #{pid}")
    
    pid_result = -1
    
    if pid > 0 
      begin
        pid_result = Process.kill( 0, pid)
      rescue Exception
      end
    end

    pid_status = "nicht aktiv"
    if pid_result != -1 
      pid_status = "aktiv (PID #{pid})"
    end
    
    # print out process status
    output += cgi.h2 { "Status" } 

    output += cgi.table { 
      cgi.tr { 
        cgi.td( "WIDTH" => "200") { 
          cgi.big { "APRS4R-Software: " }
        } + 
        cgi.td( "WIDTH" => "200") {
          cgi.big { pid_status } 
        } 
      }
    }


    # print out log
    log_lines = Array.new
    begin
      File.open( log_dir + "/aprs4r.log").each{ |line|
        log_lines << line
        
        if log_lines.length > 20
          log_lines.shift
        end
      }
    rescue Exception
    end
    
    output += cgi.h2 { "Log" } 

    if log_lines.length > 0 
      output += cgi.small { cgi.small { cgi.pre { log_lines } } }
    else
      output += cgi.p { "Keine Daten in #{log_dir}/aprs4r.log gefunden" }
    end

    return output
  end
  
end


