
require 'aprs4r/APRS4RLogger'

include APRS4R


class LogStatusHandler

  @logger = APRS4RLogger.get_logger( "LogStatusHandler")


  def LogStatusHandler.header
    return "Status - Log"
  end


  def LogStatusHandler.handle_request( cgi)
    # logger.info( "handle_request( cgi)")

    log_dir = ENV['APRS4R_LOG'] || "/var/log/aprs4r"
    # logger.debug( "log_dir: #{log_dir}")

    output = ""

    # print out log
    log_log4r = Array.new
    begin
      File.open( log_dir + "/aprs4r.log").each{ |line|
        log_log4r << line
        
        if log_log4r.length > 50
          log_log4r.shift
        end
      }
    rescue Exception
    end
    
    output += cgi.h2 { "Daten-Log" } 
    if log_log4r.length > 0 
      output += cgi.small { cgi.small { cgi.pre { log_log4r } } }
    else
      output += cgi.p { "Keine Meldungen" }
    end


    # print stderr log
    log_stderr = Array.new
    begin
      File.open( log_dir + "/aprs4r-stderr.log").each{ |line|
        log_stderr << line
        
        if log_stderr.length > 20
          log_stderr.shift
        end
      }
    rescue Exception
    end
    
    output += cgi.h2 { "Fehler-Log" } 
    if log_stderr.length > 0 
      output += cgi.small { cgi.small { cgi.pre { log_stderr } } }
    else
      output += cgi.p { "Keine Meldungen" }
    end


    # print stdout log 
    log_stdout = Array.new
    begin
      File.open( log_dir + "/aprs4r-stdout.log").each{ |line|
        log_stdout << line
        
        if log_stdout.length > 20
          log_stdout.shift
        end
      }
    rescue Exception
    end
    
    output += cgi.h2 { "Standard-Log" } 
    if log_stdout.length > 0 
      output += cgi.small { cgi.small { cgi.pre { log_stdout } } }
    else
      output += cgi.p { "Keine Meldungen" }
    end
    
    return output
  end

end






