
require 'aprs4r/APRS4RLogger'

include APRS4R


class StartupStatusHandler

  @@logger = APRS4RLogger.get_logger( "StartupStatusHandler")


  def StartupStatusHandler.header
    return "Status - Start"
  end


  def StartupStatusHandler.cgi_parameter( cgi, name)
    value = nil

    parameter = cgi.params[name]
    
    if parameter 
      value = parameter[0]
    end

    return value
  end


  def StartupStatusHandler.handle_request( cgi)
    @@logger.info( "handle_request( cgi)")

    etc_dir = ENV['APRS4R_ETC'] || "/etc/aprs4r"
    @@logger.debug( "etc_dir: #{etc_dir}")

    default_file = ENV['APRS4R_DEFAULT'] || "/etc/default/aprs4r"
    @@logger.debug( "default_file: #{default_file}")

    pid_file = ENV['APRS4R_PID'] || "/var/run/aprs4r.pid"
    @@logger.debug( "pid_file: #{pid_file}")

    daemon_file = ENV['APRS4R_DAEMON'] || "/usr/bin/aprs4r"
    @@logger.debug( "daemon_file: #{daemon_file}")

    # list config files
    config_files = Array.new
    Dir.new( etc_dir).sort.each { |name|
      if name =~ /\.yaml$/ && name != "default.yaml"
        config_files << name
      end
    }

    

    action = "unknown"
    action = "start" if cgi_parameter( cgi, 'start')
    action = "stop" if cgi_parameter( cgi, 'stop')
    action = "save" if cgi_parameter( cgi, 'save')

    result = nil
    
    @@logger.debug( "action: #{action}")
    
    if action == "start"
      @@logger.debug( "start command")

      file = cgi_parameter( cgi, 'file')
      config_file = nil
      config_file = File.basename( file) if file

      @@logger.debug( "system: #{daemon_file} #{etc_dir}/#{config_file}")

      `#{daemon_file} #{etc_dir}/#{config_file}`
      result = $?

      sleep 5
    elsif action == "stop" 
      @@logger.debug( "stop command")
      
      # read out pid file
      pid = -1
      
      begin 
        File.open( pid_file).each { |line|
          pid = line.chomp!.to_i if line && line =~ /^[0-9]*$/
        }
      rescue Exception
      end
      
      @@logger.debug( "pid: #{pid}")

      # send kill signal 
      if pid > 0 
        begin
          Process.kill( 9, pid)
        rescue Exception => ex
          @@logger.error( "Error sending KILL signal to pid: #{pid}, ex: #{ex}")
        end
      end

      sleep 5
    elsif action == "save"
      @@logger.debug( "save command")
      file = cgi_parameter( cgi, 'file')
      config_file = File.basename( file) if file
      boot = cgi_parameter( cgi, 'boot')

      @@logger.debug( "file: #{file}")
      @@logger.debug( "config_file: #{config_file}")
      @@logger.debug( "boot: #{boot}")

      if config_files.include?( config_file)
        begin
          File.open( default_file, "w") { |file|
            file.puts( "#")
            file.puts( "# aprs4r default file")
            file.puts( "#")
            file.puts

            if boot == "true"
              file.puts( "START_DAEMON=\"true\"")
            else
              file.puts( "START_DAEMON=\"false\"")
            end

            file.puts
            file.puts( "PROFILE=\"#{config_file}\"")
            file.puts
          }

        rescue Exception => ex
          @@logger.error( "Error writing default file #{default_file}")
        end
      end
    end


    # auto start 
    boot_options = [ [ "true", "ja"], ["false", "nein", true] ]
    start_boot = false
    begin
      File.new( default_file).each{ |line|
        if line =~ /START_DAEMON/ && (line =~ /true/ || line =~ /TRUE/)
          start_boot = true
          boot_options = [ [ "true", "ja", true], ["false", "nein"] ]
        end
      }
    rescue Exception
    end
    
    # start profile
    start_profile = ""
    begin
      File.new( default_file).each{ |line|
        if line =~ /PROFILE/
          start_profile = line.chomp!.split( /\=/)[1]
          start_profile.gsub!( /\"/, "")
        end
      }
    rescue Exception
    end


    profile_options = []
    config_files.each{ |config_file|
      @@logger.debug( "config_file: #{config_file}")
      if config_file == start_profile
        profile_options << [config_file, config_file, true]
      else 
        profile_options << [config_file, config_file]
      end
    }


    # read out pid file
    pid = -1
    
    begin 
      File.open( pid_file).each { |line|
        pid = line.chomp!.to_i if line && line =~ /^[0-9]*$/
      }
    rescue Exception
    end
    
    @@logger.debug( "pid: #{pid}")
    # process check
    pid_result = -1
    
    if pid > 0 
      begin
        pid_result = Process.kill( 0, pid)
      rescue Exception
      end
    end

    pid_status = "nicht aktiv"
    if pid_result != -1 
      pid_status = "aktiv (PID #{pid})"
    end
    

    output = "" 

    # manual start/stop
    output += cgi.h2 { "Manuelles Starten/Stoppen" } 

    output += cgi.table { 
      cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/status/startup") { 

        cgi.tr { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "APRS4R-Software:" } 
          } + 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { pid_status } 
          } + 
          cgi.td { }
        } + 

        cgi.tr { 
          cgi.td { cgi.big { "Aktion: " } } + 
          cgi.td { 
            form_output = "" 

            if pid_result == -1 
              form_output = cgi.popup_menu( "NAME" => "file", "VALUES" => profile_options) 
            end

            form_output
          } + 
          cgi.td { 
            form_output = "" 

            if pid_result == -1 
              form_output = cgi.submit( "VALUE" => "Starten", "NAME" => "start")
            else 
              form_output = cgi.submit( "VALUE" => "Stoppen", "NAME" => "stop")
            end
            
            form_output
          }
        }
      }
    }
    

    # automatic start at boot
    output += cgi.h2 { "Automatischer Start" } 

    output += cgi.table { 
      cgi.form( "ACTION" => "/aprs4r-web/cgi-bin/admin.rb/status/startup") { 

        cgi.tr { 
          cgi.td( "WIDTH" => "200") { 
            cgi.big { "Start beim Booten:" } 
          } + 
          cgi.td( "WIDTH" => "200") { 
            cgi.popup_menu( "NAME" => "boot", "VALUES" => boot_options)
          } + 
          cgi.td { }
        } + 

        cgi.tr { 
          cgi.td { cgi.big { "Startprofil:" } } + 
          cgi.td { 
            cgi.popup_menu( "NAME" => "file", "VALUES" => profile_options) 
          } + 
          cgi.td { 
            cgi.submit( "Speichern", "save") 
          }
        }
      }
    }
    
    return output
  end

end

