
require 'cgi'

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRS4RConfiguration'
require 'aprs4r/ConfigurationAttribute'

require 'aprs4r/PluginConfiguration'
require 'aprs4r/GatewayPluginConfiguration'
require 'aprs4r/DigipeaterPluginConfiguration'

require 'aprs4r-web/AbstractHandler'

include APRS4R


class DigipeaterSetupHandler < AbstractHandler

  @@logger = APRS4RLogger.get_logger( "DigipeaterSetupHandler")


  def DigipeaterSetupHandler.header
    return "Setup - Gateway/Digipeater"
  end


  def DigipeaterSetupHandler.handle_request( cgi)
    @@logger.info( "handle_request( cgi)")

    session = load_session

    configuration = nil
    configuration = session['config'] if session

    if configuration.nil?
      return cgi.h3( "ALIGN" => "center", "STYLE" => "color:red") { 
        "Kein Profil geladen oder Zeitberschreitung!" + 
        cgi.a( "/aprs4r-web/cgi-bin/admin.rb/setup") { "Hier laden." }
      } 
    end

    if configuration.plugins.nil?
      configuration.plugins = Hash.new
    end

    plugins = configuration.plugins

    # filter out beacons
    beacons = Hash.new

    if plugins && ! plugins.empty?
      plugins.each{ |id, plugin|
        @@logger.debug( "plugin: #{plugin}, class: #{plugin.class}")
        if plugin.type =~ /(Gateway|Digipeater)Plugin/
          beacons[id] = plugin
          plugins.delete( id)
        end
      }
    end

    beacon_types = Array.new
    PluginConfiguration.subtypes.each{ |type|
      if type =~ /(Gateway|Digipeater)Plugin/
        beacon_types << type
      end
    }

    # process input
    action = handle_input( cgi, session, beacons, "plugin", beacon_types, "digipeater")
    
    if beacons && ! beacons.empty?
      beacons.each{ |id, plugin| 
        plugins[id] = plugin
      }
    end


    if action == "new" || action == "update" || action == "delete"
      session['config'] = configuration
      session['changed'] = true
      session['timestamp'] = Time.now
      save_session( session)
    end

    # generate html output
    output = "" 

    if session['changed']
      output += cgi.h3( "ALIGN" => "right", "STYLE" => "color:red") { 
        "Achtung: Profil noch nicht gespeichert !" +
        cgi.a( "/aprs4r-web/cgi-bin/admin.rb/setup") { "Hier speichern." }
      } 
    end

    output += create_output( cgi, "Gateway/Digipeater", beacons, "Gateway/Digipeater", beacon_types, "/aprs4r-web/cgi-bin/admin.rb/setup/digipeater")

    return output 
  end

end




