
require 'cgi'

begin
  log4r_name = ENV['APRS4R_WEB_LOG4R'] || "/etc/aprs4r-web/aprs4r-web.log4r"
  APRS4RLogger.load_yaml_file( log4r_name)
rescue Exception => ex
  printf( $stderr, "Error loading log4r configuration: #{log4r_name}, ex: #{ex}\n")
  exit 8
end

@@logger = APRS4RLogger.get_logger( "download")


def handle_request( cgi, session)

  etc_dir = ENV['APRS4R_ETC'] || "/etc/aprs4r"
  @@logger.debug( "etc_dir: #{etc_dir}")

  file = cgi['file']

  config_file = nil
  config_file = File.basename( file) if file
  @@logger.debug( "config_file: #{config_file}")

  output = "" 
  if config_file 
    output = "Content-Disposition: attachment; filename=#{config_file}"
    output += "\n\n"

    begin 
      File.open( etc_dir + "/" + config_file).each { |line|
        output += line
      }
    rescue Exception 
    end
  else
    output = "Content-Type: text/plain"
    output += "\n\n"

    output += "File #{config_file} not found..."
  end

  return output
end

cgi = CGI.new( "html4")

print handle_request( cgi, nil)
