#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2009 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'fileutils'

module APRS4R

  # we want to see stacktraces from all threads
  Thread.abort_on_exception = true

  # load log4r 
  require 'aprs4r/APRS4RLogger'
  
  begin
    log4r_name = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/aprs4r.log4r"
    APRS4RLogger.load_yaml_file( log4r_name)
  rescue Exception => ex
    printf( $stderr, "Error loading log4r configuration: #{log4r_name}, ex: #{ex}\n")
    exit 8
  end


  # load version information
  require 'aprs4r/APRS4RVersion'

  # load configuration
  require 'aprs4r/APRS4RConfiguration'

  output = APRS4RConfiguration.update_configuration( ARGV[0])

  output.each{ |line|
    printf( line)
  }

end

