#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"

print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'

APRS4R::APRS4RLogger::load_yaml_file( log4r_file)

require 'aprs4r/APRSMessage'
require 'aprs4r/TestSocket'


module APRS4R 

  class TestSocketTest < Test::Unit::TestCase

    @@logger = APRS4RLogger.get_logger( "GatewayPluginTest")

    
    def setup
      @@logger.info( "setup")

      configuration = nil

      @socket = TestSocket.new
      @socket.setup( configuration)

      @socket.delayed_initialize

      return
    end


    def test_recv_single

      message1 = APRSMessage.new( "FROM", "TO", [], ">recv message1")

      assert_not_nil( @socket)

      @socket.recv( message1)
      message1_recv = @socket.read_message

      assert_equal( message1, message1_recv)

      return
    end


    def test_recv_multiple

      message1 = APRSMessage.new( "FROM", "TO", [], ">recv message1")
      message2 = APRSMessage.new( "FROM", "TO", [], ">recv message2")
      message3 = APRSMessage.new( "FROM", "TO", [], ">recv message3")
      message4 = APRSMessage.new( "FROM", "TO", [], ">recv message4")
      message5 = APRSMessage.new( "FROM", "TO", [], ">recv message5")
      message6 = APRSMessage.new( "FROM", "TO", [], ">recv message6")

      assert_not_nil( @socket)

      @socket.recv( message1)
      @socket.recv( message2)
      @socket.recv( message3)
      @socket.recv( message4)
      @socket.recv( message5)
      @socket.recv( message6)

      message1_recv = @socket.read_message
      assert_equal( message1, message1_recv)

      message2_recv = @socket.read_message
      assert_equal( message2, message2_recv)

      message3_recv = @socket.read_message
      assert_equal( message3, message3_recv)

      message4_recv = @socket.read_message
      assert_equal( message4, message4_recv)

      message5_recv = @socket.read_message
      assert_equal( message5, message5_recv)

      message6_recv = @socket.read_message
      assert_equal( message6, message6_recv)

      return
    end


    def test_send_single
      @@logger.info( "test_send_single")

      message1 = APRSMessage.new( "FROM", "TO", [], ">send message1")

      assert_not_nil( @socket)

      @socket.write_message( message1)
      message1_send = @socket.send

      assert_equal( message1, message1_send)

      return
    end
      

    def test_send_multiple

      message1 = APRSMessage.new( "FROM", "TO", [], ">send message1")
      message2 = APRSMessage.new( "FROM", "TO", [], ">send message2")
      message3 = APRSMessage.new( "FROM", "TO", [], ">send message3")
      message4 = APRSMessage.new( "FROM", "TO", [], ">send message4")
      message5 = APRSMessage.new( "FROM", "TO", [], ">send message5")
      message6 = APRSMessage.new( "FROM", "TO", [], ">send message6")

      assert_not_nil( @socket)

      @socket.write_message( message1)
      @socket.write_message( message2)
      @socket.write_message( message3)
      @socket.write_message( message4)
      @socket.write_message( message5)
      @socket.write_message( message6)

      message1_send = @socket.send
      assert_equal( message1, message1_send)

      message2_send = @socket.send
      assert_equal( message2, message2_send)

      message3_send = @socket.send
      assert_equal( message3, message3_send)

      message4_send = @socket.send
      assert_equal( message4, message4_send)

      message5_send = @socket.send
      assert_equal( message5, message5_send)

      message6_send = @socket.send
      assert_equal( message6, message6_send)

      return
    end
    
  end

end
  
