#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRSCall'
require 'aprs4r/APRSMessage'

require 'aprs4r/extensions/Extension'
require 'aprs4r/extensions/OptimizePathExtensionConfiguration'


module APRS4R

  class OptimizePathExtension < Extension

    @logger = APRS4RLogger.get_logger( "OptimizePathExtension")


    def initialize
      logger.info( "initialize")

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      return
    end


    def handle_message( name, message, repeat)
      logger.info( "handle_message( name, message, repeat)")

      return [@@RESULT_ACCEPT, nil] if message.nil? || message.path.nil?

      path = message.path
      path_new = Array.new

      # search for last repeated flag
      repeated_index = 0
      for i in 0...path.length
        entry = APRSCall.parse( path[i])

        repeated_index = i+1 if entry.repeated
      end

      logger.debug( "optimize_path: repeated_index: #{repeated_index}")

      for i in 0...repeated_index 
        logger.debug( "optimize_path: adding entry: #{path[i]}")
        path_new << path[i]
      end

      last_wide_ssid = 0
      for i in repeated_index...path.length
        entry = path[i]
        logger.debug( "entry: #{entry}")
        call = APRSCall.parse( entry)
        current_ssid = call.ssid

        if call.call =~ /WIDE[2-9]/ && call.ssid > 0 
          if last_wide_ssid + current_ssid <= 7
            last_wide_ssid += current_ssid
          else 
            wide_new = "WIDE" + last_wide_ssid.to_s + "-" + last_wide_ssid.to_s
            wide_new = "WIDE2-1" if wide_new == "WIDE1-1"
            path_new << wide_new
            last_wide_ssid = current_ssid
          end
        else     
          logger.debug( "optimize_path: adding entry: #{call}")
          path_new << entry
        end

      end

      if last_wide_ssid > 0 
        wide_new = "WIDE" + last_wide_ssid.to_s + "-" + last_wide_ssid.to_s
        wide_new = "WIDE2-1" if wide_new == "WIDE1-1"
        path_new << wide_new
      end

      message.path = path_new

      return [@@RESULT_ACCEPT, message]
    end

  end

end
