#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/SpeechPlugin'
require 'aprs4r/WeatherPlugin'
require 'aprs4r/WeatherSpeechPluginConfiguration'


module APRS4R

  class WeatherSpeechPlugin < SpeechPlugin

    @logger = APRS4RLogger.get_logger( "WeatherSpeechPlugin")


    def initialize
      logger.info( "initialize")
      
      super

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      return
    end


    def create_text
      logger.info( "create_text")
      
      weather_plugin = @plugin_manager.get_plugin( WeatherPlugin)

      # build aprs weather message
      if weather_plugin
        
        # wind
        wind_direction = weather_plugin.wind_direction 
        wind_orientation = orientation( wind_direction)
        wind_avg = weather_plugin.wind_avg
        wind_gust = weather_plugin.wind_gust

        # temperature 
        temperature = weather_plugin.temperature

        # rain
        rain_1h = weather_plugin.rain_1h
        rain_24h = weather_plugin.rain_24h
        rain_today = weather_plugin.rain_today

        # humidity 
        humidity = weather_plugin.humidity

        # pressure 
        pressure = weather_plugin.pressure

        message = ""
        begin
          message = eval( "\"#{@text}\"")
        rescue Exception => ex
          logger.warn( "eval: #{ex}")
        end

        logger.debug( "message: #{message}")

        return message
      end

      return nil
    end


    def orientation( direction)
      logger.info( "orientation( direction)")

      level = (90 / 2 / 2).to_f

      value = (direction + level) % 360

      index = (value / (2 * level)).to_i

      logger.warn( "level: #{level}, value: #{value}, index: #{index}")

      orientations = [ "nord", "nordost", "ost", "suedost", "sued", "suedwest", "west", "nordwest"]

      return orientations[index]

      

      return "nord" if value < 90

      return "ost" if value < 180

      return "sued" if value < 270

      return "west" if value < 360

      return "unbekannt"
    end

  end

end
