#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/BeaconPlugin'
require 'aprs4r/APRSCall'
require 'aprs4r/ScheduleBeaconPluginConfiguration'


module APRS4R

  class ScheduleBeaconPlugin < BeaconPlugin

    @logger = APRS4RLogger.get_logger( "ScheduleBeaconPlugin")


    def initialize
      logger.info( "initialize")

      super

      return
    end

    
    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      # start parameters



      date_match = /^[0-9][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]$/
      time_match = /^[0-2][0-9]:[0-5][0-9]$/
      day_match = /^[1-7](\/[1-4])?$/


      # date
      @startDate = nil
      @endDate = nil

      startDate = configuration.startDate
      endDate = configuration.endDate

      if startDate && endDate
        if startDate =~ date_match && endDate =~ date_match
          year, month, day = startDate.split( /-/)
          @startDate = Time.local( year, month, day)

          year, month, day = endDate.split( /-/)
          @endDate = Time.local( year, month, day)
        end
      end


      # time
      @startTime = nil
      @endTime = nil

      startTime = configuration.startTime
      endTime = configuration.endTime

      if startTime && endTime
        if startTime =~ time_match && endTime =~ time_match
          hour, minute = startTime.split( /:/)
          @startTime = hour.to_i * 60 + minute.to_i

          hour, minute = endTime.split( /:/)
          @endTime = hour.to_i * 60 + minute.to_i
        end
      end


      # day
      @startDay = nil
      @startWeek = nil
      @endDay = nil
      @endWeek = nil

      startDay = configuration.startDay
      endDay = configuration.endDay

      if startDay && endDay 
        if startDay =~ day_match && endDay =~ day_match
          day, week = startDay.split( /\//)
          @startDay = day.to_i
          @startWeek = week.to_i if week
          
          day, week = endDay.split( /\//)
          @endDay = day.to_i
          @endWeek = week.to_i if week
        end
      end

      # logger.debug( "startDay: #{@startDay}, startWeek: #{@startWeek}")
      # logger.debug( "endDay: #{@endDay}, endWeek: #{@endWeek}")

      return
    end


    def create_beacon( now = Time.now)
      logger.info( "create_beacon")
      
      # check date
      if @startDate && @endDate
        return nil if now < @startDate || now > @endDate
      end

      # check time
      if @startTime && @endTime
        minutes = now.hour * 60 + now.min
        return nil if minutes < @startTime || minutes > @endTime
      end

      # check day 
      if @startDay && @endDay
        if @startWeek && @endWeek

          week_day = Date.new( now.year, now.month, 1)

          startDay = 0
          startWeek = 0
          
          endDay = 0
          endWeek = 0

          begin
            if startWeek < @startWeek
              if week_day.cwday == @startDay
                startWeek += 1 
              end
              startDay += 1
            end

            if endWeek < @endWeek
              if week_day.cwday == @endDay
                endWeek += 1
              end
              endDay += 1
            end

            week_day = week_day.next
          end while week_day.mon == now.month

          # logger.debug( "startDay: #{startDay}, endDay: #{endDay}, nowDay: #{now.day}")

          return nil if now.day < startDay || now.day > endDay

        else
          date = Date.new( now.year, now.month, now.day)
          return nil if date.cwday < @startDay || date.cwday > @endDay
        end

      end

      message = @message.clone

      return message
    end

  end
  
end
