#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'

require 'aprs4r/PluginConfiguration'

require 'aprs4r/SocketManager'
require 'aprs4r/PluginManager'


module APRS4R

  class Plugin < APRS4RBase

    @logger = APRS4RLogger.get_logger( "Plugin")


    def initialize
      logger.info( "initialize")

      @socket_manager = SocketManager.get_instance
      @plugin_manager = PluginManager.get_instance

      return
    end

    
    def setup( configuration)
      logger.info( "setup( configuration)")
      
      @name = configuration.name
      @type = configuration.type

      @enable = false 
      @enable = true if configuration.enable == true

      return
    end


    def start
      logger.info( "start")
    end


    def stop
      logger.info( "stop")
    end

  end

end
