#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRSCall'


module APRS4R

  class MICEMessage < APRS4RBase

    @logger = APRS4RLogger.get_logger( "MICEMessage")


    def MICEMessage.latitude( message)
      logger.info( "latitude( message)")

      if message.nil? || !message.is_mice?
        return 0.0
      end

      latitude = 0.0

      logger.debug( "destination: #{message.destination}")
      logger.debug( "length: #{message.destination.length}")

      if message.destination.nil? 
        return 0.0
      end

      call = APRSCall.parse( message.destination)

      if call && call.call && call.call.length >= 6 
        degrees = 0.0

        # degrees
        if call.call[0].chr =~ /[0-9]/
          degrees += (call.call[0].to_i - 48) * 10.0
        elsif call.call[0].chr =~ /[A-J]/
          degrees += (call.call[0].to_i - 65) * 10.0
        elsif call.call[0].chr =~ /[P-Y]/
          degrees += (call.call[0].to_i - 80) * 10.0
        end

        if call.call[1].chr =~ /[0-9]/
          degrees += call.call[1].to_i - 48
        elsif call.call[1].chr =~ /[A-J]/
          degrees += call.call[1].to_i - 65
        elsif call.call[1].chr =~ /[P-Y]/
          degrees += call.call[1].to_i - 80
        end

        minutes = 0.0

        # minutes 
        if call.call[2].chr =~ /[0-9]/
          minutes += (call.call[2].to_i - 48) * 10.0
        elsif call.call[2].chr =~ /[A-J]/
          minutes += (call.call[2].to_i - 65) * 10.0
        elsif call.call[2].chr =~ /[P-Y]/
          minutes += (call.call[2].to_i - 80) * 10.0
        end

        if call.call[3].chr =~ /[0-9]/
          minutes += call.call[3].to_i - 48
        elsif call.call[3].chr =~ /[A-J]/
          minutes += call.call[3].to_i - 65
        elsif call.call[3].chr =~ /[P-Y]/
          minutes += call.call[3].to_i - 80
        end

        # seconds
        if call.call[4].chr =~ /[0-9]/
          minutes += (call.call[4].to_i - 48) / 10.0
        elsif call.call[4].chr =~ /[A-J]/
          minutes += (call.call[4].to_i - 65) / 10.0
        elsif call.call[4].chr =~ /[P-Y]/
          minutes += (call.call[4].to_i - 80) / 10.0
        end

        if call.call[5].chr =~ /[0-9]/
          minutes += (call.call[5].to_i - 48) / 100.0
        elsif call.call[5].chr =~ /[A-J]/
          minutes += (call.call[5].to_i - 65) / 100.0
        elsif call.call[5].chr =~ /[P-Y]/
          minutes += (call.call[5].to_i - 80) / 100.0
        end

        logger.debug( "latitude: degrees: #{degrees} minutes: #{minutes}")

        latitude = degrees + minutes / 60.0
        
        latitude *= -1.0 if call.call[3].chr =~ /[0-9L]/
      end

      logger.debug( "latitude: #{latitude}")

      return latitude
    end


    def MICEMessage.longitude( message)
      logger.info( "longitude( message)")
      
      if message.nil? || !message.is_mice?
        return 0.0
      end

      longitude = 0.0

      
      if message.destination.nil? 
        return 0.0
      end

      call = APRSCall.parse( message.destination)

      if call && call.call && call.call.length >= 6 && message.payload && message.payload.length >= 4
        
        # degrees
        degrees = message.payload[1].to_i - 28

        # +100 offset
        if call.call[4].chr =~ /[P-Z]/
          degrees += 100
        end
        
        
        # corrections
        if degrees >= 180 && degrees < 190
          degrees -= 80
        elsif degrees >= 190 && degrees < 200 
          degrees -= 190
        end

        # minutes
        minutes = (message.payload[2].to_i - 28).to_f
        minutes -= 60.0 if minutes >= 60.0

        # seconds
        minutes += (message.payload[3].to_i - 28).to_f / 100.0

        logger.debug( "longitude: degrees: #{degrees} minutes: #{minutes}")

        longitude = degrees + minutes / 60.0

        longitude *= -1.0 if call.call[5].chr =~ /[P-Z]/
      end

      logger.debug( "longitude: #{longitude}")

      return longitude
    end


    def MICEMessage.course_direction( message) 
      logger.info( "course_direction( message)")
      
      if message.nil? || !message.is_mice?
        return 0 
      end

      direction = 0 

      if message.payload && message.payload.length >= 6
        # hundred of degrees
        value = (message.payload[5].to_i - 28) % 10
        value *= 100

        direction = value + (message.payload[6].to_i - 28)
      end

      direction -= 400 if direction >= 400

      return direction
    end


    def MICEMessage.course_speed( message)
      logger.info( "course_speed( message)")

      if message.nil? || !message.is_mice?
        return 0 
      end

      speed = 0

      if message.payload && message.payload.length >= 6
        # tens of knots
        value = (message.payload[4].to_i - 28) * 10

        # knots
        speed = value + (message.payload[5].to_i - 28) / 10
      end

      speed -= 800 if speed >= 800
      
      return speed
    end

  end

end
