#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2009 by Michael Conrad <do5mc@friggleware.de> and
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'

require 'aprs4r/KISSSerialConnection'


require 'aprs4r/KISSDeviceConfiguration'


module APRS4R 

  class KISSDevice < APRS4RBase

    @logger = APRS4RLogger.get_logger( "KISSDevice")

    
    def initialize( configuration, mode)
      logger.info( "initialize( configuration, mode")

      return if configuration.nil?

      configuration.port = KISSDeviceConfiguration::KISS_DEFAULT_PORT if configuration.port.nil?
      @port = configuration.port

      @device = KISSSerialConnection.get_device( configuration, mode)

      return
    end


    def read_frame
      logger.info( "read_frame")

      return @device.read_frame( @port)
    end

    
    def write_frame( message)
      logger.info( "write_frame( message)")

      @device.write_frame( @port, message)

      return
    end

  end

end
