#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"

print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'
include APRS4R

APRS4RLogger::load_yaml_file( log4r_file)

require 'aprs4r/APRSMessage'
require 'aprs4r/DigipeaterPlugin'
require 'aprs4r/DigipeaterPluginConfiguration'


class SSDigipeaterPluginTest < Test::Unit::TestCase

  
  def setup
    configuration = DigipeaterPluginConfiguration.new

    configuration.device = "test0"
    configuration.call = "DIGI"
    configuration.mode = "wide"
    configuration.aliases = [ "DIGI"]
    configuration.state = "DEBW"
    configuration.rfonly = true
    configuration.reducePath = true
    configuration.permittedHops = 1

    @plugin = DigipeaterPlugin.new( configuration)
  end

  
  def test_empty_path

    message = APRSMessage.new( "DO5MC", "AP4R10", [], ">test message")

    print "message: #{message}\n"

    result = @plugin.do_digipeating( "test0", message)
    assert_nil( result)

    print "result: #{result}\n"

    return
  end


  def test_used_path

    message = APRSMessage.new( "DO5MC", "AP4R10", [ "DIGI1", "DIGI2", "DIGI3*"], ">test message")

    print "message: #{message}\n"

    result = @plugin.do_digipeating( "test0", message)
    assert_nil( result)

    print "result: #{result}\n"

    return
  end

  
  def test_path_ss1_1

    message = APRSMessage.new( "DO5MC", "AP4R10", [ "DEBW1-1"], ">test message")

    print "message: #{message}\n"

    result = @plugin.do_digipeating( "test0", message)
    assert( result)

    print "result: #{result}\n"

    return
  end

  
  def test_path_ss3_3

    message = APRSMessage.new( "DO5MC", "AP4R10", [ "DEBW3-3"], ">test message")

    print "message: #{message}\n"

    result = @plugin.do_digipeating( "test0", message)
    assert( result)

    print "result: #{result}\n"

    return
  end


  def test_path_ss_wide

    message = APRSMessage.new( "DO5MC", "AP4R10", [ "WIDE1-1", "DEBW3-3"], ">test message")

    print "message: #{message}\n"

    result = @plugin.do_digipeating( "test0", message)
    assert( result)

    print "result: #{result}\n"

    return
  end

  
  def test_no_ss

    print "test_no_ss\n"

    configuration = DigipeaterPluginConfiguration.new

    configuration.device = "test0"
    configuration.call = "DIGI"
    configuration.mode = "wide"
    configuration.aliases = [ "DIGI"]
    configuration.state = nil
    configuration.rfonly = true
    configuration.reducePath = true
    configuration.permittedHops = 1

    plugin = DigipeaterPlugin.new( configuration)

    message1 = APRSMessage.new( "DO5MC", "AP4R10", [ "DEBW1-1"], ">test message")
    message2 = APRSMessage.new( "DO5MC", "AP4R10", [ "DEBW3-3"], ">test message")
    message3 = APRSMessage.new( "DO5MC", "AP4R10", [ "WIDE1-1", "DEBW3-3"], ">test message")

    print "message1: #{message1}\n"
    result1 = plugin.do_digipeating( "test0", message1)
    assert_nil( result1)

    print "message2: #{message2}\n"
    result2 = plugin.do_digipeating( "test0", message2)
    assert_nil( result2)

    print "message3: #{message3}\n"
    result3 = plugin.do_digipeating( "test0", message3)
    assert( result3)
    print "result3: #{result3}\n"

    return
  end
    


end
  
