#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/extensions/Extension'
require 'aprs4r/extensions/DigipeaterExtensionConfiguration'


module APRS4R

  class DigipeaterExtension < Extension

    @logger = APRS4RLogger.get_logger( "DigipeaterExtension")


    def initialize
      logger.info( "initialize")

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      @call = nil
      @call = configuration.call if configuration.call

      @mode = "fillin" 
      @mode = "wide" if configuration.mode == "wide"

      @aliases = Array.new
      if configuration.aliases
        configuration.aliases.each{ |entry|
          call = APRSCall.parse( entry)
          @aliases << call
        }
      end

      @state = nil
      @state = configuration.state if configuration.state

      @rfonly = false
      @rfonly = configuration.rfonly if configuration.rfonly

      if @call.to_s =~ /^MYCALL/i
        raise "DigipeaterExtension: extension: #{@name}, invalid call: #{@call}, please use valid call"
      end

      return
    end


    def handle_message( name, message, repeat)
      logger.info( "handle_message( name, message, repeat)")

      return [@@RESULT_ACCEPT, nil] if message.nil? || message.path.nil? || message.path.empty?

      path = message.path
      
      # search for last repeated flag
      repeated_index = 0
      for i in 0...path.length
        entry = APRSCall.parse( path[i])
        
        repeated_index = i+1 if entry.repeated
      end
      
      wide_keyword = /WIDE1/
      wide_keyword = /(WIDE|#{@state})1/ if @state
      if @mode == "wide"
        wide_keyword = /WIDE[1-7]/
        wide_keyword = /(WIDE|#{@state})[1-7]/ if @state
      end
      
      # search for keyword
      for i in repeated_index...path.length
        entry = APRSCall.parse( path[i])
        
        # check for wide keyword
        if entry.call =~ wide_keyword && entry.ssid > 0 
          entry.decrease_ttl
          digi = APRSCall.parse( @call)

          if entry.ssid == 0 
            path.delete_at( i)
          else
            path[i] = entry.to_s
          end
          
          digi.repeated = true 
          path.insert( i, digi.to_s)
          
          return [@@RESULT_ACCEPT, message]
        end
        
        # check for aliases (and replace and disable digipeater call)
        if @aliases.include?( entry)
          call = APRSCall.parse( @call)
          call.repeated = true 
          path[i] = call.to_s
          
          return [@@RESULT_ACCEPT, message]
        end
        
      end
      
      return [@@RESULT_DROP, nil]
    end

  end

end
