#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2009 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"

print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'

APRS4R::APRS4RLogger::load_yaml_file( log4r_file)

require 'aprs4r/APRS4RBase'

require 'aprs4r/ISSocket'
require 'aprs4r/ISSocketConfiguration'



module APRS4R

  class ISSocketBenchmarks < APRS4RBase

    @logger = APRS4RLogger.get_logger( "ISSocketBenchmarks")


    def parse_message_benchmark( iterations)
      logger.info( "parse_message_benchmark( iterations)")

      data = "DO5MC>AP4R10,PATH1,PATH2:>This is a test payload"

      socket = ISSocket.new

      start = Time.now
      
      iterations.times {
        message = socket.parse_message( data)

        if message.nil?
          logger.error( "parse_message failed")
        end
      }

      stop = Time.now

      duration = stop - start

      logger.log( "iterations: #{iterations}, duration: #{duration}, performance: #{iterations.to_f/duration.to_f}")

    end


    def socket_benchmark
      logger.info( "socket_benchmark")

      socket = ISSocket.new
      configuration = ISSocketConfiguration.new

      configuration.name = "is0"
      configuration.type = "ISSocket"
      configuration.enable = true

      configuration.hosts = [ "localhost" ]
      configuration.port = 14580
      configuration.username = "DO5MC-15"
      configuration.filter = ""
      configuration.duplicatePeriod = 15
      configuration.timeout = 5
      
      socket.setup( configuration)

      socket.delayed_initialize

      messages = 0

      start = Time.now

      message = socket.read_message

      while !message.nil?
        messages += 1
        logger.debug( "loop: #{messages} message: #{message}")

        message = socket.read_message
      end

      stop = Time.now

      duration = stop - start - configuration.timeout
      
      logger.log( "messages: #{messages}, duration: #{duration}, performance: #{messages.to_f/duration.to_f}")
      
    end

  end


  # main
  if __FILE__ == $0

    benchmark = ISSocketBenchmarks.new

    if false 
      # warmup
      benchmark.parse_message_benchmark( 1000)
      
      # hot runs
      benchmark.parse_message_benchmark( 10)
      benchmark.parse_message_benchmark( 10)
      benchmark.parse_message_benchmark( 10)
      
      benchmark.parse_message_benchmark( 100)
      benchmark.parse_message_benchmark( 100)
      benchmark.parse_message_benchmark( 100)
      
      benchmark.parse_message_benchmark( 1000)
      benchmark.parse_message_benchmark( 1000)
      benchmark.parse_message_benchmark( 1000)
      
      benchmark.parse_message_benchmark( 10000)
      benchmark.parse_message_benchmark( 10000)
      benchmark.parse_message_benchmark( 10000)
    end

    benchmark.socket_benchmark

  end


end
