#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRSMessage'
require 'aprs4r/Plugin'
require 'aprs4r/WeatherPluginConfiguration'


module APRS4R
  
  class WeatherPlugin < Plugin
    
    # alle units are SI units !!!
    
    attr_accessor :wind_direction, :wind_avg, :wind_gust, :rain_1h, :rain_24h, :rain_today, :temperature, :humidity, :pressure, :luminosity

    @logger = APRS4RLogger.get_logger( "WeatherPlugin")


    def initialize
      logger.info( "initialize")

      super

      return
    end

    
    def setup( configuration)
      logger.info( "setup( configuration)")
      
      super( configuration)

      @update_timestamp = nil
      
      return
    end


    def update_timestamp
      @update_timestamp = Time.now
    end


    def is_uptodate?( period)

      return false if @update_timestamp.nil?

      return false if Time.now - @update_timestamp > period

      return true
    end
    
    
    def WeatherPlugin.celcius_to_fahrenheit( value)
      return nil if value.nil? || !value.is_a?( Numeric)
      return value * 1.8 + 32
    end


    def WeatherPlugin.fahrenheit_to_celcius( value)
      return nil if value.nil? || !value.is_a?( Numeric)
      return (value - 32) / 1.8
    end

    
    def WeatherPlugin.meter_to_inch( value)
      return nil if value.nil? || !value.is_a?( Numeric)
      return value * 100.0 / 2.54
    end


    def WeatherPlugin.inch_to_meter( value)
      return nil if value.nil? || !value.is_a?( Numeric)
      return value * 2.54 / 100.0
    end


    def WeatherPlugin.mps_to_mph( value)
      return nil if value.nil? || !value.is_a?( Numeric)
      return value / 0.44704
    end

    
    def WeatherPlugin.mph_to_mps( value)
      return nil if value.nil? || !value.is_a?( Numeric)
      return value * 0.44704
    end

    
    def WeatherPlugin.mps_to_knots( value)
      return nil if value.nil? || !value.is_a?( Numeric)
      return value / 0.51444
    end


    def WeatherPlugin.knots_to_mps( value) 
      return nil if value.nil? || !value.is_a?( Numeric)
      return value * 0.51444
    end


    def WeatherPlugin.knots_to_mph( value)
      return nil if value.nil? || !value.is_a?( Numeric)
      return value / 0.8689762
    end


    def WeatherPlugin.mps_to_kph( value) 
      return nil if value.nil? || !value.is_a?( Numeric)
      return value * 3.6
    end


    def WeatherPlugin.kph_to_mps( value) 
      return nil if value.nil? || !value.is_a?( Numeric)
      return value / 3.6
    end

  end

end
