#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'
require 'aprs4r/BeaconPluginConfiguration'


module APRS4R

  class ScheduleBeaconPluginConfiguration < BeaconPluginConfiguration

    attr_accessor :startDate, :startTime, :startDay, :endDate, :endTime, :endDay


    def to_yaml_properties
      return super + %w{ @startDate @startTime @startDay @endDate @endTime @endDay}
    end

    
    def attributes
      
      attributes = [ 
                    ConfigurationAttribute.new( "startDate", "text", true, 10, nil, "Startdatum"),
                    ConfigurationAttribute.new( "startTime", "text", true, 6,  nil, "Startzeit"),
                    ConfigurationAttribute.new( "startDay",  "text", true, 6,  nil, "Startwochentag"),

                    ConfigurationAttribute.new( "endDate", "text", true, 10, nil, "Enddatum"),
                    ConfigurationAttribute.new( "endTime", "text", true, 6,  nil, "Endzeit"),
                    ConfigurationAttribute.new( "endDay",  "text", true, 6,  nil, "Endwochentag")

                   ]

      return super + attributes 
    end

  end

end
