#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'
require 'aprs4r/PluginConfiguration'


module APRS4R

  class SamplePluginConfiguration < PluginConfiguration

    attr_reader :attribute1, :attribute2
    attr_writer :attribute2, :attribute2

    def initialize( attribute1 = nil, attribute2 = nil)
      @attribute1 = attribute1
      @attribute2 = attribute2
    end

    def to_yaml_properties
      return super + %w{@attribute1 @attribute2}
    end

    def attributes
      
      attributes = [ 
                    ConfigurationAttribute.new( "attribute1", "text", true, 10, "default", "Attribute 1 (String)"),
                    ConfigurationAttribute.new( "attribute2", "number", true, 10, "0", "Attribute 2 (Zahl)")
                   ]

      return super + attributes
    end

  end

end
