#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/BeaconPlugin'
require 'aprs4r/APRSCall'
require 'aprs4r/ProportionalBeaconPluginConfiguration'
require 'aprs4r/SocketManager'


module APRS4R

  class ProportionalBeaconPlugin < BeaconPlugin

    @logger = APRS4RLogger.get_logger( "ProportionalBeaconPlugin")


    def initialize
      logger.info( "initialize")

      super

      @hop_index = 1

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)
      
      begin
        @hops = 2
        @hops = configuration.hops.to_i if configuration.hops
        @hops = 7 if @hops > 7
      rescue Exception => ex 
        logger.error( "Error reading variable hops: #{configuration.hops}")
      end

      begin
        @rate = 3
        @rate = configuration.rate.to_i if configuration.rate
        @rate = 2 if @rate < 2
      rescue Exception => ex
        logger.error( "Error reading variable rate: #{configuration.rate}")
      end

      begin 
        @fillinHop = nil
        @fillinHop = configuration.fillinHop.to_s if configuration.fillinHop

        # we dont want generic calls here
        if ! @fillinHop.nil? 
          if @fillinHop =~ /^(RELAY|WIDE|TRACE|(WIDE|TRACE)[0-9]-[0-9])$/ || @fillinHop.empty?
            logger.warn( "removing generic call (#{@fillinHop}) from fillinHop")
            @fillinHop = nil
          end
        end
      rescue Exception => ex
        logger.error( "Error reading variable fillinHop: #{configuration.fillinHop}")
      end

      return
    end
      

    def create_beacon
      logger.info( "create_beacon")

      message = @message.clone

      current_hops = 0 

      # calculate hop count
      0.upto( @hops) { |hop|
        if @hop_index % @rate ** hop == 0
          current_hops = hop
        end
      }
      
      # build new path
      new_path = Array.new
      
      if @fillinHop != nil
        new_path << @fillinHop
      end
      
      if current_hops == 1 
        new_path << "WIDE2-1" 
      elsif current_hops > 1
        new_path << "WIDE#{current_hops}-#{current_hops}"
      end

      message.path = new_path

      @hop_index += 1

      return message
    end

  end

end
