#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'socket'

require 'aprs4r/APRS4RLogger'

require 'aprs4r/PositionPlugin'


module APRS4R

  class GPSDPositionPlugin < PositionPlugin

    @logger = APRS4RLogger.get_logger( "GPSDPositionPlugin")


    def initialize
      logger.info( "initialize")

      super
      
      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      @socket = TCPSocket.new( localhost, 2947)
      
      return
    end


    def start
      logger.info( "start")

      return
    end


    def latitude
      logger.info( "latitude")
      
      @socket.puts( "p")
      result = @socket.gets

      return result.scan( /P=(.[^ ]+) (.[^ ]+)/)[0]
    end

    
    def longitude
      logger.info( "longitude")
      
      @socket.puts( "p")
      result = @socket.gets

      return result.scan( /P=(.[^ ]+) (.[^ ]+)/)[1]
    end


    def speed 

    end


    def course

    end

  end

end
