#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'

require 'aprs4r/Configuration'


module APRS4R

  class DeviceConfiguration < Configuration

    attr_accessor :mode

    def online_url
      return "http://www.aprs4r.org/cgi-bin/trac.cgi/wiki/APRS4RConfigurationDevices#{@type}German"
    end

    
    def initialize
      super

    end
    
    def attributes
      attributes = [
                    ConfigurationAttribute.new( "type", "text", false, 10, nil, "Typ"), 
                   ]

      # return super + attributes
      return attributes
    end


    def DeviceConfiguration.subtypes
      return [ "KISSDevice", 
               "UDPDevice"
             ]
    end

  end

end
