#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"
print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'
APRS4R::APRS4RLogger::load_yaml_file( log4r_file)

require 'aprs4r/UDPDevice'


module APRS4R

  class UDPDeviceTest < Test::Unit::TestCase

    @@logger = APRS4RLogger.get_logger( "UDPDeviceTest")


    def _test_empty_calc_crc
      device = UDPDevice.new( nil)

      data = []
      crc = device.calc_crc( data)

      @@logger.debug( "data: #{data.join( ',')}")
      @@logger.debug( "crc: X#{crc.join( ',')}X")
    end


    def _test_empty_check_crc
      device = UDPDevice.new( nil)

      data = [0, 0]
      result = device.check_crc( data)

      @@logger.debug( "result: #{result}")
    end      
      
    
    def test_calc_crc
      device = UDPDevice.new( nil)

      data = Array.new( 256)

      for i in 0...256
        data[i] = i
      end

      crc = device.calc_crc( data)

      printf( "crc: %x,%x\n", crc[0], crc[1])

      @@logger.debug( "data: #{data.join( ',')}")
      @@logger.debug( "crc: #{crc.join( ',')}")
    end

    
    def test_check_crc

      device = UDPDevice.new( nil)

      data = Array.new( 256)

      for i in 0...256
        data[i] = i
      end

      data.concat( device.calc_crc( data))

      result = device.check_crc( data)

      @@logger.debug( "result: #{result}")
    end

  end

end
  
