#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/server/filter/Filter'


module APRS4R

  class EntryFilter < Filter

    @logger = APRS4RLogger.get_logger( "EntryFilter")


    def initialize( entries)
      logger.info( "initialize( entries)")

      @entries = Array.new

      if entries.is_a?( Array)
        entries.each{ |entry|
          @entries << entry.to_s
        }
      end

      return
    end


    def match( message)
      logger.info( "match")
      
      return false if message.nil?

      entry_call = message.entry_call

      return false if entry_call.nil? || entry_call.empty?

      @entries.each{ |entry|
        # TODO handle wildcard
        return true if entry_call == entry
      }
      
      return false
    end

  end

end
