#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RTest'

require 'aprs4r/APRSMessage'

require 'aprs4r/extensions/Extension'
require 'aprs4r/extensions/TranslatePathExtension'
require 'aprs4r/extensions/TranslatePathExtensionConfiguration'


module APRS4R 

  class TranslatePathExtensionTest < APRS4RTest

    @logger = APRS4RLogger.get_logger( "TranslatePathExtensionTest")


    def setup
      logger.info( "setup")

      configuration = TranslatePathExtensionConfiguration.new
      configuration.name = "translate"
      configuration.type = "TranslatePathExtension"
      configuration.enable = true

      @extension = TranslatePathExtension.new
      @extension.setup( configuration)

      @device = "test0"
      @repeat = false

      return
    end


    def test_nil
      logger.info( "test_nil")
      
      message1 = nil

      result, result1 = @extension.handle_message( @device, message1, @repeat)

      assert( result, Extension.RESULT_ACCEPT)
      assert_nil( result1)
    end


    def test_relay
      logger.info( "test_relay")

      message1_path = ["RELAY", "RELAY*", "RELAY", "RELAY"]
      message1 = APRSMessage.new( "FROM", "TO", message1_path, "")
      logger.error( "message1.path: #{message1.path}")

      result, result1 = @extension.handle_message( @device, message1, @repeat)
      result1_path = ["RELAY", "RELAY*", "WIDE2-1", "WIDE2-1"]

      logger.error( "result1.path: #{result1.path}")

      assert( result, Extension.RESULT_ACCEPT)
      assert_equal( result1.path, result1_path)
    end


    def test_used_relay
      logger.info( "test_used_relay")
      
      message1_path = ["RELAY*", "WIDE*", "WIDE", "TRACE", "TRACE4-3"]
      message1 = APRSMessage.new( "FROM", "TO", message1_path, "")

      logger.error( "message1.path: #{message1.path}")

      result, result1 = @extension.handle_message( @device, message1, @repeat)
      result1_path = ["RELAY*", "WIDE*", "WIDE2-1", "WIDE2-1", "WIDE4-3"]

      logger.error( "result1.path: #{result1.path}")

      assert( result, Extension.RESULT_ACCEPT)
      assert( result1.path, result1_path)
    end

  end

end
  
