#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2009 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'
require 'aprs4r/BeaconPluginConfiguration'


module APRS4R

  class TelemetryBeaconPluginConfiguration < BeaconPluginConfiguration

    attr_accessor :dataset_id, :period_max


    def to_yaml_properties
      return super + %w{ @dataset_id @period_max}
    end

    
    def attributes
      
      attributes = [ 
                    ConfigurationAttribute.new( "dataset_id", "number", true, 6, 0, "Index Datensatz"),
                    ConfigurationAttribute.new( "period_max", "number", true, 6, 1800, "Maximalinterval")
                   ]

      return super + attributes 
    end

  end

end
