#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'socket'
require 'thread'
require 'timeout'
require 'io/nonblock'

require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'

require 'aprs4r/ISSocket'


module APRS4R

  class ISServerSocket < APRS4RBase

    @logger = APRS4RLogger.get_logger( "ISServerSocket")


    def initialize( port)
      logger.info( "initialize( port)")

      @port = port
      @serverSocket = nil

      initISServerSocket

      return
    end

    
    def initISServerSocket()
      logger.info( "initISServerSocket")

      begin 
        @serverSocket = TCPServer.new( @port)

        @serverSocket.nonblock = true
        @serverSocket.sync = true 
        
      rescue Exception => ex
        logger.error( "Error open server socket on port #{@port}, ex: #{ex}")
      end

      return
    end


    def accept
      logger.info( "accept")

      socket = @serverSocket.accept

      # make authentication and return socket to plugin
      clientSocket = ISSocket.new
      clientSocket.setup( nil, socket)

      return clientSocket
    end

  end

end
