#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'log4r'
require 'log4r/yamlconfigurator'


module APRS4R

  class APRS4RLogger

    def APRS4RLogger.load_yaml_file( file)

      # load log4r config
      log4rConfiguration = Log4r::YamlConfigurator
      log4rConfiguration['HOME'] = '.'
      log4rConfiguration.load_yaml_file( file)

      return
    end


    def APRS4RLogger.get_logger( name)
      logger = Log4r::Logger[name]

      if logger.nil?
        logger = Log4r::Logger.new( 'default::' + name)
        logger.parent = Log4r::Logger['default']
      end

      return logger
    end


  end

end
