#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'socket'
require 'thread'
require 'timeout'
require 'io/nonblock'

require 'aprs4r/APRS4RLogger'

require 'aprs4r/ISSocket'


module APRS4R

  class T2ClientSocketError < Timeout::Error; end 

  class T2ClientSocket < ISSocket

    @logger = APRS4RLogger.get_logger( "T2ClientSocket")


    def initialize
      logger.info( "initialize")

      @thread_run = false
      @thread = nil

      super
      
    end


    def setup( socket, queue) 
      logger.info( "setup( socket, queue)")

      super( nil, socket)

      @queue = queue

      @thread_run = true
      @thread = Thread.new{ run }

      return
    end


    def read_data
      logger.info( "read_data")

      line = nil

      begin
   
        if @socket
          line = @socket.gets.force_encoding( "ISO-8859-1")
        end
        
        raise SocketError, "nil message" if line.nil?

        line.chomp! 
        logger.debug( "read_data: line: -#{line}-")

      rescue SocketError
        logger.warn( "read_data: socket ex: #{ex}")
        raise

      rescue Exception => ex
        logger.warn( "read_data: ex.class: #{ex.class}")
        logger.warn( "read_data: ex: #{ex}")
        # FIXME: insert return nil for benchmark
        # return nil
        reinit_socket 
      end until line !~ /^#/
        
      return line
    end
    


    def run 
      logger.info( "run")

      delayed_initialize

      while @thread_run
        
        begin
          Timeout::timeout( 10, T2ClientSocketError) do
            message = read_message
          end
          
        rescue T2ClientSocketError => ex
          logger.warn( "run: ex: #{ex}")
          message = nil 
          @thread_run = false 

        rescue Exception => ex
          logger.warn( "run: ex: #{ex}")
          message =  nil
        end

        if message 
          logger.log( "message recv on #{@name}: #{message}")
          # queue message in recv queue
          @queue.push( message)
        else 
          # FIXME write comment
        end
      end

      return
    end


  end

end
